/*
 * Copyright [yyyy] [name of copyright owner]
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package sgskel;

import javax.jdo.annotations.IdGeneratorStrategy;
import javax.jdo.annotations.IdentityType;
import javax.jdo.annotations.PersistenceCapable;
import javax.jdo.annotations.Persistent;
import javax.jdo.annotations.PrimaryKey;

/**
*
*/
@PersistenceCapable(identityType = IdentityType.APPLICATION)
public class Avatar
{
	/**  */
	@PrimaryKey
	@Persistent(valueStrategy = IdGeneratorStrategy.IDENTITY)
	private Long id;

	/**  */
	@Persistent
	private Integer hairNo;

	/**  */
	@Persistent
	private Integer dressNo;

	/**
	 *
	 */
	public Avatar( Integer hairNo, Integer dressNo )
	{
		this.hairNo		= hairNo;
		this.dressNo	= dressNo;
	}

	/**
	 *
	 */
	public Long getId()
	{
		return this.id;
	}
	/**
	 *
	 */
	public Integer getHairNo()
	{
		return this.hairNo;
	}
	/**
	 *
	 */
	public Integer getDressNo()
	{
		return this.dressNo;
	}
	/**
	 *
	 */
	public void setHairNo( Integer hairNo )
	{
		this.hairNo = hairNo;
	}
	/**
	 *
	 */
	public void setDressNo( Integer dressNo )
	{
		this.dressNo = dressNo;
	}
};
