/*
 * Copyright [yyyy] [name of copyright owner]
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package sgskel;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;

import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * @author hoge
 */
@SuppressWarnings({"serial", "unchecked"})
public class SgSkelServerServlet
	extends HttpServlet
{
	/**  */
	private static final String STR_ERR_UNKNOWN		= "Unknown Error.";
	/**  */
	private static final String STR_ERR_PROTOCOL	= "Protocol Error.";

	/**  */
	private static final String CMD_GET				= "get";
	/**  */
	private static final String CMD_UPDATE			= "update";

	/**  */
	private static final PersistenceManagerFactory pmfInstance = 
		JDOHelper.getPersistenceManagerFactory("transactions-optional");
	/**  */
	private static final Logger logger = Logger.getLogger( SgSkelServerServlet.class.getName() );

	/**
	 *
	 */
	@Override
	public void doGet( HttpServletRequest req, HttpServletResponse resp )
		throws IOException
	{
		this.doPost( req, resp );
	}

	/**
	 *
	 */
	@Override
	public void doPost( HttpServletRequest req, HttpServletResponse resp )
		throws IOException
	{
		try
		{
			req.setCharacterEncoding("UTF-8");
			String cmd	= req.getParameter("cmd");
			if ( cmd.equals( CMD_GET ) )
			{
				Avatar avatar	= this.getAvatar();
				this.output( req, resp, avatar );
			}
			else if ( cmd.equals( CMD_UPDATE ) )
			{
				String hairNo		= req.getParameter("hairNo");
				String dressNo		= req.getParameter("dressNo");
				if ( hairNo == null || dressNo == null )
				{
					this.outputError( req, resp, STR_ERR_PROTOCOL );
				}
				else
				{
					Avatar avatar	= this.updateAvatar(
						Integer.valueOf( hairNo ),
						Integer.valueOf( dressNo ) );
					this.output( req, resp, avatar );
				}
			}
			else
			{
				this.outputError( req, resp, STR_ERR_PROTOCOL );
			}
		}
		catch ( Throwable e )
		{
			this.outputError( req, resp, STR_ERR_UNKNOWN + ", " + e.toString() );
			logger.log( Level.ALL, e.getMessage() );
		}
	}
	/**
	 *
	 */
	private Avatar getAvatar()
		throws Exception
	{
		PersistenceManager pm = pmfInstance.getPersistenceManager();
		try
		{
			String query = "select from " + Avatar.class.getName();
			List<Avatar> avatars = (List<Avatar>) pm.newQuery( query ).execute();
			if ( avatars.isEmpty())
			{
				return new Avatar( 0, 0 );
			}
			else
			{
				return avatars.get(0);
			}
		}
		finally
		{
			pm.close();
		}
	}
	/**
	 *
	 */
	private Avatar updateAvatar( Integer hairNo, Integer dressNo )
		throws Exception
	{
		Avatar avatar = null;

		PersistenceManager pm = pmfInstance.getPersistenceManager();
		try
		{
			String query = "select from " + Avatar.class.getName();
			List<Avatar> avatars = (List<Avatar>) pm.newQuery( query ).execute();
			if ( avatars.isEmpty())
			{
				avatar = new Avatar( hairNo, dressNo );
				pm.makePersistent( avatar );
			}
			else
			{
				avatar = avatars.get(0);
				avatar.setHairNo( hairNo );
				avatar.setDressNo( dressNo );
				//...pm.close()で更新される
			}
		}
		finally
		{
			pm.close();
		}
		return avatar;
	}
	/**
	 *
	 */
	private void outputError(
		HttpServletRequest req, HttpServletResponse resp,
		String errorMessage )
	{
		try
		{
			resp.setContentType("text/plain; charset=UTF-8");
			PrintWriter out = resp.getWriter();
	
			out.print("{ \"errorMessage\" : \"" + errorMessage + "\"}" );
			out.close();
		}
		catch ( Throwable e )
		{
			logger.log( Level.ALL, e.getMessage() );
		}
	}
	/**
	 *
	 */
	private void output(
		HttpServletRequest req,
		HttpServletResponse resp,
		Avatar avatar )
		throws Exception
	{
		resp.setContentType("text/plain; charset=UTF-8");
		PrintWriter out = resp.getWriter();
		
		out.print("{\n");
		out.print("\t\"avatar\" : {\n");
		out.print("\t\t\"hairNo\" : " + avatar.getHairNo() + ",\n" );
		out.print("\t\t\"dressNo\" : " + avatar.getDressNo() + "\n" );
		out.print("\t}\n");
		out.print("}");

		out.close();
	}

};
