/*
 * Copyright [yyyy] [name of copyright owner]
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


// Anonymous function start
//
(function( window, undefined )
{

/**
 * Config
 */
var Config =
{
	loopInterval	: 35,
	loadInterval	: 2000,
	serverPath		: "/SgSkelServer"
};

/**
 * Res
 */
var Res =
{
	String :
	{
		TITLE			: "SG SKEL (簡易アバター)",
		BUTTON_READ		: "読み込み",
		BUTTON_WRITE	: "書き込み",
		SUCCESS_READ	: "サーバデータの読み込みに成功しました。",
		SUCCESS_WRITE	: "サーバデータの書き込みに成功しました。",
		FAILURE_CONN	: "サーバへの接続に失敗しました。"
	},
	Color :
	{
		BACKGROUND		: "rgb(0, 0, 0)",
		TITLE_TEXT		: "white",
		BUTTON_RECT		: "crimson",
		BUTTON_TEXT		: "white"
	},
	Font :
	{
		LARGE		: "bold 18px 'ＭＳ Ｐゴシック'",
		SMALL		: "bold 14px 'ＭＳ Ｐゴシック'"
	}
};

/**
 * Data
 */
var Data =
{
	resource :
	{
		image	:
		{
			body	: { name : "image/body.png" },
			hair	: { name : "image/hair.png" },
			dress	: { name : "image/dress.png" },
			right	: { name : "image/right.png" },
			left	: { name : "image/left.png" }
		}
	}
};

/**
 * Debug
 */
var Debug = new function()
{
	/**
	 * メッセージボックスを表示する。
	 */
	this.alert = function( message )
	{
		window.alert( message );
	};
	/**
	 * メッセージボックスを表示する。
	 */
	this.alertError = function( err )
	{
		var str =
			"name=" + err.name + "\n" +
			"message=" + err.message + "\n" +
			"lineNumber=" + err.lineNumber + "\n" +
			err.stack;

		window.alert( str );
	};
}();

/**
 * AvatarTask
 */
var AvatarTask = function()
{
	this.needUpdate	= true;
	this.data		=
	{
		hairNo	: 0,
		dressNo	: 0
	};
	this.reading	= false;
	this.writing	= false;
};

(function( pt )
{
	pt.CELL_W	= 64;
	pt.CELL_H	= 96;

	/**
	 * 
	 */
	pt.update = function( scene )
	{
		var upd = this.needUpdate;
		this.needUpdate	= false;

		var hairLength	= Math.floor( Data.resource.image.hair.data.width / this.CELL_W );
		var dressLength	= Math.floor( Data.resource.image.dress.data.width / this.CELL_W );
		var baseUrl		= scene.baseUrl;
		var self		= this;

		if ( scene.leftHButtonTask.clicked )
		{
			scene.leftHButtonTask.clicked	= false;

			this.data.hairNo--;
			if ( this.data.hairNo < 0 )
			{
				this.data.hairNo	= hairLength - 1;
			}
		}
		else if ( scene.rightHButtonTask.clicked )
		{
			scene.rightHButtonTask.clicked	= false;

			this.data.hairNo++;
			if ( this.data.hairNo >= hairLength )
			{
				this.data.hairNo	= 0;
			}
		}
		else if ( scene.leftDButtonTask.clicked )
		{
			scene.leftDButtonTask.clicked	= false;

			this.data.dressNo--;
			if ( this.data.dressNo < 0 )
			{
				this.data.dressNo	= dressLength - 1;
			}
		}
		else if ( scene.rightDButtonTask.clicked )
		{
			scene.rightDButtonTask.clicked	= false;

			this.data.dressNo++;
			if ( this.data.dressNo >= dressLength )
			{
				this.data.dressNo	= 0;
			}
		}
		else if ( scene.readButtonTask.clicked )
		{
			scene.readButtonTask.clicked	= false;

			if ( this.reading ) { return false; }
			this.reading	= true;

			var params = {};
			params[ gadgets.io.RequestParameters.CONTENT_TYPE ]	= gadgets.io.ContentType.JSON;
			params[ gadgets.io.RequestParameters.METHOD ]		= gadgets.io.MethodType.POST;
			params[ gadgets.io.RequestParameters.POST_DATA ]	= gadgets.io.encodeValues( { cmd : "get", nocache : "0" } );

			var url	= baseUrl.match(/(^[httpsfile]+:\/{2,3}[0-9a-z\.\-:]+?:?[0-9]*?)\//i)[1];
			url += Config.serverPath;

			gadgets.io.makeRequest( url, function( obj ){ self.responseRead( obj ); }, params );
		}
		else if ( scene.writeButtonTask.clicked )
		{
			scene.writeButtonTask.clicked	= false;

			if ( this.writing ) { return false; }
			this.writing	= true;

			var params = {};
			params[ gadgets.io.RequestParameters.CONTENT_TYPE ]	= gadgets.io.ContentType.JSON;
			params[ gadgets.io.RequestParameters.METHOD ]		= gadgets.io.MethodType.POST;
			params[ gadgets.io.RequestParameters.POST_DATA ]	= gadgets.io.encodeValues(
				{ cmd : "update", hairNo : this.data.hairNo, dressNo : this.data.dressNo, nocache : "0" } );

			var url	= baseUrl.match(/(^[httpsfile]+:\/{2,3}[0-9a-z\.\-:]+?:?[0-9]*?)\//i)[1];
			url += Config.serverPath;

			gadgets.io.makeRequest( url, function( obj ){ self.responseWrite( obj ); }, params );
		}
		return upd;
	};
	/**
	 * 
	 */
	pt.responseRead = function( obj )
	{
		this.reading	= false;

		var jsonData = obj.data;
		if ( jsonData )
		{
			if ( jsonData.avatar )
			{
				this.data.hairNo	= jsonData.avatar.hairNo;
				this.data.dressNo	= jsonData.avatar.dressNo;
				this.needUpdate	= true;
	
				Debug.alert( Res.String.SUCCESS_READ );
			}
			else //if ( jsonData.errorMessage )
			{
				Debug.alert( jsonData.errorMessage );
			}
		}
		else { Debug.alert( Res.String.FAILURE_CONN ); }
	};
	/**
	 * 
	 */
	pt.responseWrite = function( obj )
	{
		this.writing	= false;

		var jsonData = obj.data;
		if ( jsonData )
		{
			if ( jsonData.avatar )
			{
				Debug.alert( Res.String.SUCCESS_WRITE );
			}
			else //if ( jsonData.errorMessage )
			{
				Debug.alert( jsonData.errorMessage );
			}
		}
		else { Debug.alert( Res.String.FAILURE_CONN ); }
	};
	/**
	 * 
	 */
	pt.draw = function( scene )
	{
		var context		= scene.context;
		var canvas		= context.canvas;

		context.save();

		// clear
		context.fillStyle = Res.Color.BACKGROUND;
		context.fillRect( 0, 0, canvas.width, canvas.height );

		// title
		context.font		= Res.Font.LARGE;
		context.fillStyle	= Res.Color.TITLE_TEXT;
		context.fillText( Res.String.TITLE, 20, 40 );

		// body
		var image	= Data.resource.image.body.data;
		var sx		= 0;
		var sy		= 0;
		var sw		= this.CELL_W;
		var sh		= this.CELL_H;
		var dx		= ( canvas.width  - this.CELL_W ) / 2;
		var dy		= ( canvas.height - this.CELL_H ) / 2;
		var dw		= this.CELL_W;
		var dh		= this.CELL_H;
		context.drawImage( image, sx, sy, sw, sh, dx, dy, dw, dh );

		// dress
		image	= Data.resource.image.dress.data;
		sx		= this.data.dressNo * this.CELL_W;
		context.drawImage( image, sx, sy, sw, sh, dx, dy, dw, dh );

		// hair
		image	= Data.resource.image.hair.data;
		sx		= this.data.hairNo * this.CELL_W;
		context.drawImage( image, sx, sy, sw, sh, dx, dy, dw, dh );

		context.restore();
	};

})( AvatarTask.prototype );

/**
 * ButtonTask
 */
var ButtonTask = function( rect, image, string )
{
	this.rect		= rect;
	this.image		= image;
	this.string		= string;
	this.clicked	= false;
	this.lag		= 0;
};

(function( pt )
{
	pt.LAG_VAL		= 4;

	/**
	 * 
	 */
	pt.update = function( scene )
	{
		var upd = false;
		var mouse	= scene.event.mouse;

		if ( this.rect.w == 0 && this.rect.h == 0 )
		{
			this.rect.w	= this.image.width;
			this.rect.h	= this.image.height;
		}

		if ( this.lag > 0 )
		{
			this.lag--;
			upd = ( this.lag == 0 );
		}
		else
		{
			if ( mouse.down &&
				 this.rect.x <= mouse.x && mouse.x <= this.rect.x + this.rect.w &&
				 this.rect.y <= mouse.y && mouse.y <= this.rect.y + this.rect.h )
			{
				this.clicked	= true;
				this.lag		= this.LAG_VAL;
				upd = true;
			}
		}
		return upd;
	};
	/**
	 * 
	 */
	pt.draw = function( scene )
	{
		var context		= scene.context;
		var canvas		= context.canvas;

		context.save();

		var px	= ( this.lag > 0 ) ? 3 : 0;
		var py	= ( this.lag > 0 ) ? 3 : 0;

		if ( this.image != null )
		{
			var image	= this.image;
			var sx	= 0;
			var sy	= 0;
			var sw	= image.width;
			var sh	= image.height;
			var dx	= this.rect.x;
			var dy	= this.rect.y;
			var dw	= image.width;
			var dh	= image.height;
			context.drawImage( image, sx, sy, sw, sh, dx + px, dy + py, dw, dh );
		}
		else if ( this.string != null )
		{
			context.fillStyle	= Res.Color.BUTTON_RECT;
			context.fillRect( this.rect.x + px, this.rect.y + py, this.rect.w, this.rect.h );

			context.font		= Res.Font.SMALL;
			context.fillStyle	= Res.Color.BUTTON_TEXT;
			context.fillText( this.string, this.rect.x + 5 + px, this.rect.y + 20 + py );
		}
		context.restore();
	};

})( ButtonTask.prototype );

/**
 * Scene
 */
var Scene = function()
{
	this.baseUrl	= null;
	this.taskList	= [];
	this.context	= null;
	this.event		=
	{
		mouse	:
		{
			down	: 0,
			x		: 0,
			y		: 0
		}
	};
	this.avatarTask			= null;
	this.leftHButtonTask	= null;
	this.rightHButtonTask	= null;
	this.leftDButtonTask	= null;
	this.rightDButtonTask	= null;
	this.readButtonTask		= null;
	this.writeButtonTask	= null;
};

(function( pt )
{
	/**
	 * 
	 */
	pt.init = function( baseUrl )
	{
		try
		{
			this.baseUrl	= baseUrl;

			// clear canvas
			this.context	= window.document.getElementById("screen").getContext("2d");
			var context		= this.context;
			var canvas		= this.context.canvas;
			context.save();
			context.fillStyle	= Res.Color.BACKGROUND;
			context.fillRect( 0, 0, canvas.width, canvas.height );
			context.restore();

			// load image
			var obj = Data.resource.image;
			for ( var key in obj )
			{
				var prop		= obj[ key ];
				prop.data		= new Image();
				prop.data.src	= this.baseUrl + "/" + prop.name;
			}

			// create task
			this.avatarTask			= new AvatarTask();
			this.taskList.push( this.avatarTask );

			this.leftHButtonTask	= new ButtonTask( { x : 50, y : 80, w : 0, h : 0 }, Data.resource.image.left.data, null );
			this.taskList.push( this.leftHButtonTask );

			this.rightHButtonTask	= new ButtonTask( { x : canvas.width - 82, y : 80, w : 0, h : 0 }, Data.resource.image.right.data, null );
			this.taskList.push( this.rightHButtonTask );

			this.leftDButtonTask	= new ButtonTask( { x : 50, y : 130, w : 0, h : 0 }, Data.resource.image.left.data, null );
			this.taskList.push( this.leftDButtonTask );

			this.rightDButtonTask	= new ButtonTask( { x : canvas.width - 82, y : 130, w : 0, h : 0 }, Data.resource.image.right.data, null );
			this.taskList.push( this.rightDButtonTask );

			this.readButtonTask	= new ButtonTask( { x : canvas.width / 2 - 85, y : canvas.height - 40, w : 80, h : 26 }, null, Res.String.BUTTON_READ );
			this.taskList.push( this.readButtonTask );

			this.writeButtonTask	= new ButtonTask( { x : canvas.width / 2 +  5, y : canvas.height - 40, w : 80, h : 26 }, null, Res.String.BUTTON_WRITE );
			this.taskList.push( this.writeButtonTask );

			var self = this;

			// register event handler
			var handler	= function( e ) { self.handleSysEvent( e ); };
			canvas.addEventListener( "mousedown",	handler, false );
			canvas.addEventListener( "mouseup",		handler, false );
			canvas.addEventListener( "mouseout",	handler, false );

			// start loop
			window.setTimeout( function() { self.loop(); }, Config.loadInterval );
		}
		catch ( e )
		{
			Debug.alertError( e );
		}
	};
	/**
	 * 
	 */
	pt.handleSysEvent = function( event )
	{
		try
		{
			var type = event.type.toLowerCase();
			if ( type == "mousedown" )
			{
				this.event.mouse.down	= 1;
				this.event.mouse.x		= event.layerX;
				this.event.mouse.y		= event.layerY;
			}
			else if ( type == "mouseup" || type == "mouseout" )
			{
				this.event.mouse.down	= 0;
			}
		}
		catch ( e )
		{
			Debug.alertError( e );
		}
	};
	/**
	 * 
	 */
	pt.loop = function()
	{
		try
		{
			var upd = false;
			for ( var i = 0; i < this.taskList.length; i++ )
			{
				if ( this.taskList[i].update( this ) ) { upd = true; }
			}
			if ( upd )
			{
				for ( var i = 0; i < this.taskList.length; i++ )
				{
					this.taskList[i].draw( this );
				}
			}
			// continue main loop
			var self = this;
			window.setTimeout( function() { self.loop(); }, Config.loopInterval );
		}
		catch ( e )
		{
			Debug.alertError( e );
		}
	};
})( Scene.prototype );

// Expose
if ( !window.sgskel ) { window.sgskel = {}; }

window.sgskel.Scene		= Scene;

// Anonymous function end
//
})( window );

