#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <errno.h>

struct	timespec	timeout;
fd_set	read_set;
fd_set	fd_save;

void	pselectSet (void)
{
	FD_ZERO (&fd_save);
	timeout.tv_sec = 0;
	timeout.tv_nsec = 10000000;
}

int
main()
{
	int	ret;
 	int 	sock;
 	struct	sockaddr_in	addr;
	struct	sockaddr_in	senderinfo;
	struct	sockaddr_in	fwd_addr;
	socklen_t	addrlen;
	char	senderstr[16];

 	char	buf[64];
	char	send_buff[32];

	int	recv_sw;

 	sock = socket(AF_INET, SOCK_DGRAM, 0);

	addr.sin_family = AF_INET;
	addr.sin_port = htons(30010);
	addr.sin_addr.s_addr = INADDR_ANY;

 	bind(sock, (struct sockaddr *)&addr, sizeof(addr));

	FD_SET (sock, &fd_save);
	recv_sw = 0;

	while (1)
	{
		memcpy (&read_set, &fd_save, sizeof(fd_set));
		ret = pselect (FD_SETSIZE, &read_set, (fd_set *)NULL,
			(fd_set *)NULL, &timeout, NULL);
		if (ret > 0)
		{
			if (FD_ISSET (sock, &read_set))
			{
 				memset(buf, 0, sizeof(buf));
				addrlen = sizeof(senderinfo);
 				ret = recvfrom(sock, buf, sizeof(buf), 0, (struct sockaddr *)&senderinfo, &addrlen);
				if (ret == 10)
				{
					memcpy (&fwd_addr, &senderinfo, sizeof(senderinfo));
					recv_sw = 1;
				}
				else if(recv_sw)
				{
					inet_ntop(AF_INET, &senderinfo.sin_addr, 
						senderstr, sizeof(senderstr));
					sprintf(send_buff, "%s:%d", senderstr, 
						ntohs(senderinfo.sin_port));
					sendto (sock, send_buff, 32, 0, (struct sockaddr *)&fwd_addr, sizeof(fwd_addr));
				}
			}
		}
		
	}
	close(sock);
}

