//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		AXALDevice.h
 * @brief		OpenAL foCXNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_AXALDevice_H_
#define INCG_IRIS_AXALDevice_H_

#ifdef _IRIS_SUPPORT_OPENAL

//======================================================================
// include
#include "../../iris_object.h"
#include "AXALTypes.h"

#if		defined(_WIN32)
#include <alc.h>
#elif	(defined(TARGET_OS_MAC) && TARGET_OS_MAC)
#include <OpenAL/alc.h>
#endif

namespace iris {
namespace ax {
namespace al
{

//======================================================================
// class
//! OpenAL foCXNX
class CALDevice : public IIrisObject
{
private:
	LPAXALCDEVICE	m_pDevice;	//!< OpenAL foCX
public:
	// RXgN^
	CALDevice(void);
	// fXgN^
	~CALDevice(void);

	/**
	 * @name OpenAL foCX ̎擾
	 * @{
	*/
	LPAXALCDEVICE				GetDevice(void)			{ return m_pDevice; }
					operator	LPAXALCDEVICE (void)	{ return GetDevice(); }
	LPAXALCDEVICE	operator	() (void)				{ return GetDevice(); }
	/**
	 * @}
	*/

public:
	// 쐬
	bool		Open(LPCAXALSTR deviceSpecifier=nullptr);
	// 
	bool		Close(void);
};

}	// end of namespace al
}	// end of namespace ax
}	// end of namespace iris

#endif

#endif
