<?php
// K-12向け日本語言語パック開発支援Ｗｅｂツール（カナ文字検索：外来語）
// 2010/05/01(Sat) T.Shirai (shirai@mech.suzuka-ct.ac.jp)

require_once "config.php";
require_once "lib.php";

print_header("K-12向け日本語言語パック開発用支援環境：言語パックの外来語のチェック");

    if (!can_execute()) {
        echo 'サーバの負担が大きいため，外部の方は利用できません．ごめんなさい．<br />';
        bye();
    }

    if (!empty($_GET['check_kana'])) $targetname = $_GET['check_kana'];

    // 設定のチェック（config.phpを参照）
    initialize_settings($targetname);

    include "version.php";
    echo "<hr />\n";
    echo "<b>{$lang->desc}</b><br />\n";
    echo "<hr />\n";

    // フォルダの確認
    if (!file_exists($lang->root)) {
        echo $lang->root.'フォルダが存在しません．<br />';
        bye();
        if (!is_dir($lang->root)) {
            echo $lang->root.'はフォルダではありません．<br />';
            bye();
        }
    }

    // 再帰的にチェック
    $cnt = (object)null;
    $cnt->totalfiles = $cnt->totallines = 0;        // チェックした対象
    $cnt->files = $cnt->lines = $cnt->words = 0;    // 検査に該当した対象
    $cnt->kanawords = array();                      // 外来語の一覧と出現頻度
    $output = '';     // 検査結果のHTMLデータ
    if (langfiles_check($lang->root, 'kana')) {
        echo "外来語チェックは無事に終了しました．<br />\n";
    } else {
        echo "外来語チェックは完了しませんでした．<br />\n";
    }
    echo "チェックしたファイル数：{$cnt->totalfiles}<br />\n";
    echo "チェックした行数　　　：{$cnt->totallines}<br />\n";
    echo "発見したファイル数　　：{$cnt->files}<br />\n";
    echo "発見した行数　　　　　：{$cnt->lines}<br />\n";
    echo "発見した単語数　　　　：{$cnt->words}<br />\n";
    echo "発見された単語種　　　：".count($cnt->kanawords)."<br />\n";
//  if ((count($cnt->kanawords) > 0) and debugdisplay()) {
    if (count($cnt->kanawords) > 0) {
        echo '<hr />';
        print_return();
        echo "<b>発見された外来語一覧</b><br />\n";
        display_cantread($cnt->kanawords);
    }
    echo '<hr />';
    print_return();
    echo $output;
    echo "<hr />\n";
/*
    print_return();
    if (tag_output()) {
        echo "Tags<br />\n";
        foreach ($cnt->linedata as $path=>$lines) {
            while ($line = array_shift($lines)) {
                echo $path."($line)<br />\n";
            }
        }
        echo "<hr />\n";
    }
*/
/*
    echo "for Wiki<br />\n";
    foreach ($cnt->linedata as $path=>$lines) {
        while ($line = array_shift($lines)) {
            echo mb_substr($path, mb_strlen($lang->root)+1)."($line)<br />\n";
        }
    }
    echo "<hr />\n";
*/
    echo "以上です．<br />\n";
    print_return();

print_footer();
?>
