<?php
// K-12向け日本語言語パック開発支援Ｗｅｂツール
// 2010/04/24(Sat) T.Shirai (shirai@mech.suzuka-ct.ac.jp)
// Webフォームから入力された文字列をチェックする機能 2010/04/25(Sun)

require_once "config.php";
require_once "lib.php";

print_header("K-12向け日本語言語パック開発用支援環境：フォーム入力のチェック");

    // テキストエリアのフォームを使って呼び出されているのか？
    if (empty($_POST['checkstrings'])) {
        echo '<a href="index.php">＜戻る＞</a>';
        bye();
    } else {
        $checkstrings = $_POST['checkstrings'];
    }
    // どの学年を対象とするのか？（全学年対応）
    if (!empty($_POST['grade'])) {
        $target = $_POST['grade'];
        if ($target == 'all_grade') $targetnames = $CFG->all_targetnames;
            else                    $targetnames = array($target);
    } else {
        echo "　学年の指定が不正です．（$target)<br />\n";
        bye();
    }

    include "version.php";
    $summary = '';
    foreach ($targetnames as $targetname) {
        // 設定のチェック（config.phpを参照）
        initialize_settings($targetname);

        echo "<hr />\n";
        echo "{$lang->desc}<br />\n";
        echo "<hr />\n";

        // 漢字辞書の生成
        prepare_kanjidic($targetname);
        //echo "<hr />\n";

        // チェック実行
        $result = kanji_check_strings($checkstrings);
        echo "<hr />\n";
        echo "<h3>チェック結果</h3>\n";
        echo $result->output."<br />\n";
        $summary .= $CFG->$targetname->label.'&nbsp; : &nbsp;'.$result->output."<br />\n";
        if ($result->lineflag) {
            echo "<hr />\n";
//          print_return();
            echo "　{$result->letters}箇所の漢字が読めません．<br />\n";
            echo "　読めない漢字は以下の".count($result->cantread)."種類です．<br />\n";
            echo "<br />\n";
            display_cantread($result->cantread);
        } else {
            echo "<hr />\n";
            echo "<br />\n読めない漢字はありません．<br />\n";
        }
        print_return();
    }
    if ($target == 'all_grade') {
        echo "<hr />\n";
        echo "<h3>チェック結果（要約）</h3>\n";
        echo $summary;
    }

print_footer();
?>
