<?php
// K-12向け日本語言語パック開発支援Ｗｅｂツール
// 2010/04/24(Sat) T.Shirai (shirai@mech.suzuka-ct.ac.jp)
// 共用ライブラリ

///////////
// 初期設定
///////////
$CFG->langroot = $CFG->dataroot.'/lang';
// 各学年用フォルダ
// １年生
$CFG->ja_g01->name  = 'ja_g01';
$CFG->ja_g01->label = '小学校一年生';
$CFG->ja_g01->desc  = '小学校一年生用の言語パック';
$CFG->ja_g01->root  = $CFG->langroot.'/ja_g01_utf8';  // Grade1 : 小学校一年生
// ２年生
$CFG->ja_g02->name  = 'ja_g02';
$CFG->ja_g02->label = '小学校ニ年生';
$CFG->ja_g02->desc  = '小学校二年生用の言語パック';
$CFG->ja_g02->root  = $CFG->langroot.'/ja_g02_utf8';  // Grade2 : 小学校二年生
// ３年生
$CFG->ja_g03->name  = 'ja_g03';
$CFG->ja_g03->label = '小学校三年生';
$CFG->ja_g03->desc  = '小学校三年生用の言語パック';
$CFG->ja_g03->root  = $CFG->langroot.'/ja_g03_utf8';  // Grade3 : 小学校三年生
// ４年生
$CFG->ja_g04->name  = 'ja_g04';
$CFG->ja_g04->label = '小学校四年生';
$CFG->ja_g04->desc  = '小学校四年生用の言語パック';
$CFG->ja_g04->root  = $CFG->langroot.'/ja_g04_utf8';  // Grade4 : 小学校四年生
// ５年生
$CFG->ja_g05->name  = 'ja_g05';
$CFG->ja_g05->label = '小学校五年生';
$CFG->ja_g05->desc  = '小学校五年生用の言語パック';
$CFG->ja_g05->root  = $CFG->langroot.'/ja_g05_utf8';  // Grade5 : 小学校五年生
// ６年生
$CFG->ja_g06->name  = 'ja_g06';
$CFG->ja_g06->label = '小学校六年生';
$CFG->ja_g06->desc  = '小学校六年生用の言語パック';
$CFG->ja_g06->root  = $CFG->langroot.'/ja_g06_utf8';  // Grade6 : 小学校六年生
// 中学３年生（常用漢字１９４５文字）
$CFG->ja_g09->name  = 'ja_g09';
$CFG->ja_g09->label = '中学校三年生';
$CFG->ja_g09->desc  = '中学校三年生用の言語パック（常用漢字1945文字）';
$CFG->ja_g09->root  = $CFG->langroot.'/ja_g09_utf8';  // Grade9 : 中学校三年生
// 全学年
$CFG->all_targetnames   = array('ja_g01', 'ja_g02', 'ja_g03', 'ja_g04', 'ja_g05', 'ja_g06', 'ja_g09');

// 文字識別パターン（正規表現）
$CFG->patternNormal  = '[';
$CFG->patternNormal .= 'a-z\d\n\r\t\s';
$CFG->patternNormal .= '!-~';
$CFG->patternNormal .= 'あ-んア-ヶ';
$CFG->patternNormal .= 'ァィゥェォャュョ';
$CFG->patternNormal .= 'ー。、「」【】・';
$CFG->patternNormal .= ']';

require_once "kanjidic.php";

// 学年に応じた初期設定
function initialize_settings($targetname)
{
    global $CFG, $lang;

    // 設定のチェック（config.phpを参照）
    if (empty($CFG->$targetname)) {
        echo '対象とする年代用の設定が存在しません（'.$targetname.'）<br />';
        bye();
    }
    $lang->name = $targetname;
    $lang->root = $CFG->{$targetname}->root;
    $lang->desc = $CFG->{$targetname}->desc;
}

// 辞書の準備とその結果の表示
function prepare_kanjidic($targetname)
{
    global $CFG;

    // 漢字辞書の生成
    if (!generate_kanjidic($targetname)) {
        echo '指定された値が不正です（$targetname:'.$targetname.'）．<br />';
        bye();
    }
    echo '<p><b>読める漢字は以下の'.mb_strlen($CFG->kanjidic)."文字です．</b><br />\n";
    echo $CFG->kanjidic."</p>\n";

    echo '<p><b>さらに以下の記号（'.mb_strlen($CFG->symboldic)."文字）も加えます．</b><br />\n";
    echo $CFG->symboldic."</p>\n";
}

// 学年に応じた漢字辞書の作成
function generate_kanjidic($targetname)
{
    global $CFG;
    global $kanji;

    $CFG->kanjidic = '';
    switch ($targetname) {
        case 'ja_g06':
            $CFG->kanjidic .= $kanji['ja_g06'];
        case 'ja_g05':
            $CFG->kanjidic .= $kanji['ja_g05'];
        case 'ja_g04':
            $CFG->kanjidic .= $kanji['ja_g04'];
        case 'ja_g03':
            $CFG->kanjidic .= $kanji['ja_g03'];
        case 'ja_g02':
            $CFG->kanjidic .= $kanji['ja_g02'];
        case 'ja_g01':
            $CFG->kanjidic .= $kanji['ja_g01'];
            break;
        case 'ja_g09':
            $CFG->kanjidic .= $kanji['ja_g09'];
            break;
        default:
            return false;
    }
    $CFG->symboldic = $kanji['symbol'];
    return true;
}

/////////////////////
// スイッチのチェック
/////////////////////

// 誰でも実行して良いのか？
function can_execute()
{
    global $CFG;
    if (!empty($CFG->denyEverybody) and ($CFG->denyEverybody)) return false;
//  var_dump($_SERVER['REMOTE_ADDR']);  // for debugging
//  var_dump($_SERVER['SERVER_NAME']);  // for debugging
    if (!empty($CFG->allowedServerName) and ($_SERVER["SERVER_NAME"] != $CFG->allowedServerName)) return false;
    if (!empty($CFG->allowedRemoteAddr) and ($_SERVER["REMOTE_ADDR"] != $CFG->allowedRemoteAddr)) return false;
    return true;
}

// エディタ用のタグインデックスを出力するか？
function tag_output()
{
    global $CFG;
    if (!empty($CFG->tagoutput)) return true;
    return false;
}

// 処理の途中経過も表示するのか？
function debugdisplay()
{
    if (defined('DEBUGDISPLAY') and DEBUGDISPLAY) return true;
    return false;
}

//////////////
// XHTMLの出力
//////////////

// ヘッダーの出力
function print_header($title)
{
    echo '<?xml version="1.0" encoding="UTF-8"?>'."\n";
    echo '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"'."\n";
    echo '   "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">'."\n";
    echo '<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="ja" lang="ja">'."\n";
    echo "  <head>\n";
    echo "    <title>$title</title>\n";
    echo "  </head>\n";
    echo "  <body>\n";
}

// フッターの出力
function print_footer()
{
    echo '<p><a href="http://sourceforge.jp/projects/jak12/">SourceForge.JPのプロジェクトページ</a></p>'."\n";
    echo "  </body>\n";
    echo "</html>\n";
}

// 異常終了するときもルールは守ろう
function bye()
{
    print_footer();
    die;
}

// 指定されたURLに戻るリンクボタン
function print_return($url = 'index.php')
{
    echo '<p><a href="'.$url.'">＜戻る＞</a></p>'."\n";
}

/////////////////
// 検索処理の補助
/////////////////

// 文字列の正規化
function normalize_strings($linestr)
{
    // UTF-8ではないものが混ざっている？
    $linestr = mb_convert_encoding($linestr, 'UTF-8');
    // HTMLタグを取り除く
    $linestr = strip_tags($linestr);
    // アルファベットを全て小文字に統一
    $linestr = mb_strtolower($linestr);
    // 全角英数字を半角英数字へ
    // 半角片仮名を全角片仮名へ（濁点含む）
    // 半角ひらがなを全角ひらがなへ
    $linestr = mb_convert_kana($linestr, 'asKVH');
    return $linestr;
}

// 再帰的にフォルダをチェックする関数（呼び出し用）
function langfiles_check($directory, $command, $param = null)
{
    $funcname = '';
    switch (strtolower($command)) {
        case 'kanji': $funcname = 'kanji_check_main'; break;
        case 'word' : $funcname = 'word_check_main';  break;
        case 'kana' : $funcname = 'kana_check_main';  break;
        default:
    }
    if (empty($funcname)) {
        echo "指定されたコマンドが不正です！（$command）<br />\n";
        return false;
    }

    if (!($dir = opendir($directory))) {
        echo 'フォルダの読み出しに失敗しました（'.$directory.'）．<br />';
        return false;
    }
    while (($ent = readdir($dir)) !== FALSE) {
        // 除外するもの
        if (($ent == '.') or ($ent == '..')) continue;
//      if ($ent == 'default.ttf') continue;
        $pinfo = pathinfo($ent);
        if (!empty($pinfo['extension'])) {
            $ext = strtolower($pinfo['extension']);
            if (($ext == 'ttf') or ($ext == 'png')) continue;
        }
        // 検査対象
        $target = $directory.'/'.$ent;
        if (is_dir($target)) {
            if (!langfiles_check($target, $command, $param)) {
                closedir($dir);
                return false;
            }
        } else {
            if (!$funcname($target, $param)) {
                closedir($dir);
                return false;
            }
        }
    }
    closedir($dir);
    return true;
}

// 配列形式の”読めない漢字のリスト（頻度付き）”を表示
function display_cantread($cantread)
{
    arsort($cantread);
    $line = 1;
    foreach ($cantread as $char => $num) {
        echo $line++;
        echo '&nbsp;:&nbsp;';
        echo $char.'&nbsp;';
        if (debugdisplay()) {
            echo '(';
            for ($i = 0; $i < strlen($char); $i++) printf('%02X', ord($char[$i]));
            echo ')&nbsp;';
        }
        echo ":&nbsp;{$num}&nbsp;箇所<br />\n";
    }
}

/////////////////////////
// 読めない漢字のチェック
/////////////////////////

// 引数渡しされたテキストデータのチェック（読めない漢字）
function kanji_check_strings(&$linestr)
{
    global $CFG;
    global $cnt;

    $output = '';
    $letters = 0;
    $cantread = array();
    // 文字列の正規化
    $linestr = normalize_strings($linestr);

    $lineflag = false;
    // 空行は飛ばす
    if (mb_strlen($linestr) != 0) {
        // 一文字ずつチェック
        for ($i = 0; $i < mb_strlen($linestr); $i++) {
            $charflag = false;
            $char = mb_substr($linestr, $i, 1);
            // 漢字以外の文字のチェック
            if (!mb_eregi($CFG->patternNormal, $char) and (strlen($char) > 1)) {
                // 漢字のチェック
                if (!mb_strpos($CFG->kanjidic, $char) and !mb_strpos($CFG->symboldic, $char)) {
                    // 発見！
                    $charflag = $lineflag = true;
                    $letters++;
                    if (empty($cantread[$char])) $cantread[$char] = 1;
                        else                     $cantread[$char]++;
                }
            }
            if ($charflag) $output .= '<font color="#ff0000">'.$char.'</font>';
                else       $output .= $char;
        }
    }
    $result->lineflag = $lineflag;
    $result->output   = $output;
    $result->letters  = $letters;
    $result->cantread = $cantread;
    return $result;
}

// 指定されたテキストファイルのチェック（読めない漢字が含まれないか？）
function kanji_check_main($filepath, $param = null)
{
    global $CFG;
    global $cnt;
    global $kanjidic;
    global $output;

    // 読み出し確認
    $cnt->totalfiles++;
    if (($strings = file($filepath)) == FALSE) {
        echo 'ファイルの読み出しに失敗しました（'.$filepath.'）<br />';
        return false;
    }

    if (debugdisplay()) echo $filepath.':';

    $fileflag = false;
    $line = 0;
    $lines = array();
    $_output = '';
    foreach ($strings as $linestr) {
        if (debugdisplay()) echo '*';
        $line++;
        $cnt->totallines++;

        // 行単位のチェック
        $result = kanji_check_strings($linestr);

        // 実行結果の集計
        if ($result->lineflag) {
            $cnt->letters += $result->letters;
            foreach($result->cantread as $char => $charnum) {
                if (empty($cnt->cantread[$char])) $cnt->cantread[$char]  = $charnum;
                    else                          $cnt->cantread[$char] += $charnum;
            }
            $fileflag = true;
            $_output .= "　$line : {$result->output}<br />\n";
            $cnt->lines++;
            $lines[] = $line;
        }
    }
    if (debugdisplay()) echo "<br />\n";
    if ($fileflag) {
        $cnt->files++;
        $output .= '['.$filepath."]<br />\n".$_output."<br />\n";
    } else {
        if (debugdisplay()) $output .= '['.$filepath."]<br />\n"."読めない漢字を含みません．<br />\n<br />\n";
    }
    $cnt->linedata[$filepath] = $lines;
    return true;
}

///////////////////////////
// 指定された単語のチェック
///////////////////////////

// 引数渡しされたテキストデータのチェック（指定された単語）
function word_check_inline(&$linestr, $word)
{
    global $CFG;
    global $cnt;

    $output = '';
    $words  = 0;
    // 文字列の正規化
    $linestr = normalize_strings($linestr);

    $lineflag = false;
    while (strlen($linestr) > 0) {
        $wordflag = false;
        $pos = mb_strpos($linestr, $word);
        if ($pos === false) {
            // もう無い（あるいは最初から無い）
            $output .= $linestr;
            $linestr = '';
        } else {
            // 発見！
            $lineflag = true;
            $words++;
            $output .= mb_substr($linestr, 0, $pos).'<font color="#ff0000">'.$word.'</font>';
            $linestr = mb_substr($linestr, $pos + mb_strlen($word));
        }
    }
    $result->lineflag = $lineflag;
    $result->output   = $output;
    $result->words    = $words;
    return $result;
}

// 指定されたテキストファイルのチェック（単語が含まれるか？）
function word_check_main($filepath, $word)
{
    global $CFG;
    global $cnt;
    global $output;

    // 読み出し確認
    $cnt->totalfiles++;
    if (($strings = file($filepath)) == FALSE) {
        echo 'ファイルの読み出しに失敗しました（'.$filepath.'）<br />';
        return false;
    }

    normalize_strings($word);
    if (debugdisplay()) echo $filepath.':';

    $fileflag = false;
    $line = 0;
    $lines = array();
    $_output = '';
    foreach ($strings as $linestr) {
        if (debugdisplay()) echo '*';
        $line++;
        $cnt->totallines++;

        // 行単位のチェック
        $result = word_check_inline($linestr, $word);

        // 実行結果の集計
        $cnt->words += $result->words;
        if ($result->lineflag) {
            $fileflag = true;
            $_output .= "　$line : {$result->output}<br />\n";
            $cnt->lines++;
            $lines[] = $line;
        }
    }
    if (debugdisplay()) echo "<br />\n";
    if ($fileflag) {
        $cnt->files++;
        $output .= '['.$filepath."]<br />\n".$_output."<br />\n";
    } else {
        if (debugdisplay()) $output .= '['.$filepath."]<br />\n"."指定された単語を含みません．<br />\n<br />\n";
    }
    $cnt->linedata[$filepath] = $lines;
    return true;
}

///////////////////
// 外来語のチェック
///////////////////

// 引数渡しされたテキストデータのチェック（外来語）
function kana_check_inline(&$linestr)
{
    global $CFG;
    global $cnt;

    $output = '';
    $words  = 0;
    $kanawords = array();
    // 文字列の正規化
    $linestr = normalize_strings($linestr);

    $lineflag = false;
    while (strlen($linestr) > 0) {
        $wordflag = false;
        $pos = mb_eregi('[ァ-ヶー]+',$linestr, $regs);
        if ($pos) $pos = mb_strpos($linestr, $regs[0]);
            else  $pos = false;
        if ($pos === false) {
            // もう無い（あるいは最初から無い）
            $output .= $linestr;
            $linestr = '';
        } else {
            // 発見！
            $lineflag = true;
            $words++;
            $word = $regs[0];
            if (empty($kanawords[$word])) $kanawords[$word] = 1;
                else                      $kanawords[$word]++;
            $output .= mb_substr($linestr, 0, $pos).'<font color="#ff0000">'.$word.'</font>';
            $linestr = mb_substr($linestr, $pos + mb_strlen($word));
        }
    }
    $result->lineflag  = $lineflag;
    $result->output    = $output;
    $result->words     = $words;
    $result->kanawords = $kanawords;
    return $result;
}

// 指定されたテキストファイルのチェック（外来語が含まれないか？）
function kana_check_main($filepath, $param = null)
{
    global $CFG;
    global $cnt;
    global $output;

    // 読み出し確認
    $cnt->totalfiles++;
    if (($strings = file($filepath)) == FALSE) {
        echo 'ファイルの読み出しに失敗しました（'.$filepath.'）<br />';
        return false;
    }

    if (debugdisplay()) echo $filepath.':';

    $fileflag = false;
    $line = 0;
    $lines = array();
    $_output = '';
    foreach ($strings as $linestr) {
        if (debugdisplay()) echo '*';
        $line++;
        $cnt->totallines++;

        // 行単位のチェック
        $result = kana_check_inline($linestr);

        // 実行結果の集計
        $cnt->words += $result->words;
        if ($result->lineflag) {
            foreach($result->kanawords as $kanaword => $kananum) {
                if (empty($cnt->kanawords[$kanaword])) $cnt->kanawords[$kanaword]  = $kananum;
                    else                               $cnt->kanawords[$kanaword] += $kananum;
            }
            $fileflag = true;
            $_output .= "　$line : {$result->output}<br />\n";
            $cnt->lines++;
            $lines[] = $line;
        }
    }
    if (debugdisplay()) echo "<br />\n";
    if ($fileflag) {
        $cnt->files++;
        $output .= '['.$filepath."]<br />\n".$_output."<br />\n";
    } else {
        if (debugdisplay()) $output .= '['.$filepath."]<br />\n"."外来語を含みません．<br />\n<br />\n";
    }
    $cnt->linedata[$filepath] = $lines;
    return true;
}

?>
