package jp.sourceforge.jnfc;

import java.util.ArrayList;
import java.util.List;

import jp.sourceforge.jnfc.NFCStructure.DeviceCard;
import jp.sourceforge.jnfc.NFCStructure.DeviceData;
import jp.sourceforge.jnfc.NFCStructure.DeviceInfo;
import jp.sourceforge.jnfc.NFCStructure.Felica;
import jp.sourceforge.jnfc.NFCStructure.NFC14443A;
import jp.sourceforge.jnfc.NFCStructure.NFC14443B;

import com.sun.jna.Structure;

public class NFCPolling implements Runnable {

	private static NFCPolling instance;

	private static Thread t;

	private static boolean life;

	/**
	 * mfoCX̎
	 */
	private final int deviceTypes;


	private final List<TypeNfc14443AListener> typeAListener = new ArrayList<TypeNfc14443AListener>();

	private final List<TypeNfc14443BListener> typeBListener = new ArrayList<TypeNfc14443BListener>();

	private final List<TypeNfcFelicaListener> typeFelicaListener = new ArrayList<TypeNfcFelicaListener>();

	private NFCPolling() {
		deviceTypes = NFCStructure.TYPE_NFC_14443A |
				NFCStructure.TYPE_NFC_18092_212K |
				NFCStructure.TYPE_NFC_18092_424K |
				NFCStructure.TYPE_NFC_14443B |
				NFCStructure.TYPE_NFC_JEWEL_106;
	}

	private NFCPolling(int deviceTypes) {
		this.deviceTypes = deviceTypes;
	}

	public static NFCPolling getInstance() {
		synchronized (NFCPolling.class) {
			if (instance == null) {
				instance = new NFCPolling();
			} else {
				throw new IllegalStateException("Already instance created.");
			}
		}

		return instance;
	}


	public static NFCPolling getInstance(int deviceTYpes) {
		synchronized (NFCPolling.class) {
			if (instance == null) {
				instance = new NFCPolling(deviceTYpes);
			} else {
				throw new IllegalStateException("Already instance created.");
			}
		}

		return instance;
	}


	@Override
	public void run() {

		NFC nfc = new NFC();

		try {
			nfc.initialize();

			while(life) {
				try {
					nfc.open("USB0");
					try {
						nfc.startPollMode(deviceTypes);

						DeviceCard deviceCard = nfc.waitEvent();

						if (deviceCard != null) {
							DeviceInfo deviceInfo = deviceCard.getDeviceInfo();
							switch (deviceInfo.getTargetDevice()) {
								case NFCStructure.TYPE_NFC_14443A:
									fireTypeAEvent(deviceCard.getDeviceData());
									break;
								case NFCStructure.TYPE_NFC_14443B:
									fireTypeBEvent(deviceCard.getDeviceData());
									break;
								case NFCStructure.TYPE_NFC_18092_212K:
								case NFCStructure.TYPE_NFC_18092_424K:
									fireTypeFelicaEvent(deviceCard.getDeviceData());
									break;
								case NFCStructure.TYPE_NFC_JEWEL_106:
									break;
								default:
									break;
							}

							deviceInfo.clear();
							((Structure)deviceCard.getDeviceData()).clear();
						}
					} catch (NFCException e) {

					} finally {
						nfc.stopPollMode();
					}
				} catch (NFCException e) {

				} finally {
					nfc.close();
				}
			}
		} catch (NFCException e) {

		} finally {
			try {
				nfc.uninitialize();
			} catch (NFCException e) {

			}
		}
	}

	public void start() {
		synchronized (this) {
			if (t == null) {
				life = true;
				t = new Thread(instance);
				t.start();
			}
		}
	}

	public void stop() {
		synchronized (this) {
			life = false;
		}
	}

	public boolean isAlive() {
		return t.isAlive();
	}


	private void fireTypeAEvent(DeviceData deviceData) {

		for (TypeNfc14443AListener listener : typeAListener) {
			try {
				listener.nfcEventPerformed((NFC14443A)deviceData);
			} catch (Exception e) {

			}
		}
	}

	private void fireTypeBEvent(DeviceData deviceData) {

		for (TypeNfc14443BListener listener : typeBListener) {
			try {
				listener.nfcEventPerformed((NFC14443B)deviceData);
			} catch (Exception e) {

			}
		}
	}

	private void fireTypeFelicaEvent(DeviceData deviceData) {

		for (TypeNfcFelicaListener listener : typeFelicaListener) {
			try {
				listener.nfcEventPerformed((Felica)deviceData);
			} catch (Exception e) {

			}
		}
	}

	public synchronized void addTypeAListener(TypeNfc14443AListener listener) {
		typeAListener.add(listener);
	}

	public synchronized void removeTypeAListener(TypeNfc14443AListener lisntenr) {
		typeAListener.remove(lisntenr);
	}

	public synchronized void addTypeBListener(TypeNfc14443BListener listener) {
		typeBListener.add(listener);
	}

	public synchronized void removeTypeBListener(TypeNfc14443BListener lisntenr) {
		typeBListener.remove(lisntenr);
	}

	public synchronized void addTypeFelicaListener(TypeNfcFelicaListener listener) {
		typeFelicaListener.add(listener);
	}

	public synchronized void removeTypeFelicaListener(TypeNfcFelicaListener lisntenr) {
		typeFelicaListener.remove(lisntenr);
	}
}
