package jp.sourceforge.jnfc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class VoiceWrapper {

	private Process process;

	public VoiceWrapper(String[] command) throws IOException {

		init(command);
	}

	private void init(String[] command) throws IOException {
		process = new ProcessBuilder(command).redirectErrorStream(true).start();
	}

	public void start() throws IOException {

		InputStream in = null;
		OutputStream out = null;

		try {
			in = process.getInputStream();
			try {
				out = process.getOutputStream();
			} finally {
				if (out != null) {
					out.close();
				}
			}
		} finally {
			if (in != null) {
				in.close();
			}
		}
	}
}
