/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.factory;

import org.seasar.framework.container.factory.AnnotationHandler;
import org.seasar.framework.container.factory.ConstantAnnotationHandler;
import org.seasar.framework.exception.ClassNotFoundRuntimeException;
import org.seasar.framework.util.ClassUtil;

public class AnnotationHandlerFactory {
    private static final String TIGER_ANNOTATION_HANDLER_CLASS_NAME = "org.seasar.framework.container.factory.TigerAnnotationHandler";
    private static AnnotationHandler annotationHandler;

    protected static void initialize() {
        if (annotationHandler != null) {
            return;
        }
        Class clazz = ConstantAnnotationHandler.class;
        try {
            clazz = ClassUtil.forName(TIGER_ANNOTATION_HANDLER_CLASS_NAME);
        }
        catch (ClassNotFoundRuntimeException classNotFoundRuntimeException) {
            // empty catch block
        }
        annotationHandler = (AnnotationHandler)ClassUtil.newInstance(clazz);
    }

    public static AnnotationHandler getAnnotationHandler() {
        AnnotationHandlerFactory.initialize();
        return annotationHandler;
    }

    public static void setAnnotationHandler(AnnotationHandler handler) {
        annotationHandler = handler;
    }

    static {
        AnnotationHandlerFactory.initialize();
    }
}

