/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.servlet;

import com.google.inject.Binding;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Scope;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.servlet.GuiceFilter;
import com.google.inject.spi.BindingScopingVisitor;
import com.google.inject.spi.DefaultBindingScopingVisitor;
import java.lang.annotation.Annotation;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletScopes {
    public static final Scope REQUEST = new Scope(){

        public <T> Provider<T> scope(Key<T> key, final Provider<T> creator) {
            final String name = key.toString();
            return new Provider<T>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public T get() {
                    HttpServletRequest request;
                    HttpServletRequest httpServletRequest = request = GuiceFilter.getRequest();
                    synchronized (httpServletRequest) {
                        Object t = request.getAttribute(name);
                        if (t == null) {
                            t = creator.get();
                            request.setAttribute(name, t);
                        }
                        return t;
                    }
                }

                public String toString() {
                    return String.format("%s[%s]", creator, REQUEST);
                }
            };
        }

        public String toString() {
            return "ServletScopes.REQUEST";
        }
    };
    public static final Scope SESSION = new Scope(){

        public <T> Provider<T> scope(Key<T> key, final Provider<T> creator) {
            final String name = key.toString();
            return new Provider<T>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public T get() {
                    HttpSession session;
                    HttpSession httpSession = session = GuiceFilter.getRequest().getSession();
                    synchronized (httpSession) {
                        Object t = session.getAttribute(name);
                        if (t == null) {
                            t = creator.get();
                            session.setAttribute(name, t);
                        }
                        return t;
                    }
                }

                public String toString() {
                    return String.format("%s[%s]", creator, SESSION);
                }
            };
        }

        public String toString() {
            return "ServletScopes.SESSION";
        }
    };

    private ServletScopes() {
    }

    static boolean isSingletonBinding(Binding<?> binding) {
        final AtomicBoolean isSingleton = new AtomicBoolean(true);
        binding.acceptScopingVisitor((BindingScopingVisitor)new DefaultBindingScopingVisitor<Void>(){

            public Void visitNoScoping() {
                isSingleton.set(false);
                return null;
            }

            public Void visitScopeAnnotation(Class<? extends Annotation> scopeAnnotation) {
                if (null != scopeAnnotation && !Singleton.class.equals(scopeAnnotation)) {
                    isSingleton.set(false);
                }
                return null;
            }

            public Void visitScope(Scope scope) {
                if (null != scope && !Scopes.SINGLETON.equals(scope)) {
                    isSingleton.set(false);
                }
                return null;
            }
        });
        return isSingleton.get();
    }
}

