/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.web.action;

/* $Id: SessionTimeoutManager.java 299 2008-06-16 16:23:00Z nagashiba $ */

import javax.servlet.http.HttpServletRequest;

import org.apache.struts2.dispatcher.mapper.ActionMapping;
import org.jtp.web.SessionManager;

/**
 * セッション管理機能を提供するインターフェースです。
 *
 * @author <a href="mailto:sato-vista@tbb.t-com.ne.jp">Satoshi Nagashiba</a>
 * @version $Revision: 299 $ $Date: 2008-06-17 01:23:00 +0900 $
 */
public interface SessionTimeoutManager {

	/**
	 * セッションからセッション管理オブジェクトを取得します。
	 * @param session  処理しているHTTPセッション
	 * @return セッション管理オブジェクト
	 */
	public SessionManager getSessionManager();

	/**
	 * タイムアウト確認を行なわないかを確認します。
	 * @param mapping  このインスタンスを選択するために使用したActionMapping
     * @param request  処理しているHTTPリクエスト
	 * @return true[行わない]、false[行う]
	 */
	public boolean isSkipTimeOut(ActionMapping mapping, HttpServletRequest request);
}
