/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.web.report;

import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Iterator;

import javax.servlet.ServletContext;

import org.jtp.common.Encode;
import org.jtp.common.util.DateUtils;
import org.jtp.entity.test.TestTable;

/**
 * CSV帳票データを生成するクラスです。 
 *
 * @author <a href="mailto:sato-vista@tbb.t-com.ne.jp">Satoshi Nagashiba</a>
 * @version $Revision: 204 $ $Date: 2007-06-06 01:03:34 +0900 $
 */
public class CsvReportGenerator implements ReportGenerator, Encode {
    
	/**
     * {@inheritDoc}
     */
	@SuppressWarnings("unchecked")
    public InputStream generate(ServletContext context, Collection collection) throws IOException {
		String path = context.getRealPath("hoge.txt");
		
		//文字コード（SHIFT_JIS）指定でファイル出力
		PrintWriter pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter(new FileOutputStream(path), SJIS)));

		StringBuffer buffer = new StringBuffer();

		for (Iterator it = collection.iterator(); it.hasNext();) {
			TestTable testTable = (TestTable) it.next();
			buffer.append(testTable.getId());
			buffer.append(",");
			buffer.append(testTable.getHoge1());
			buffer.append(",");
			buffer.append(testTable.getHoge2());
			buffer.append(",");
			buffer.append(testTable.getHoge3());
			buffer.append(",");
			buffer.append(DateUtils.dateToString(testTable.getCreateDate()));
			buffer.append(",");
			buffer.append(DateUtils.dateToString(testTable.getUpdateDate()));
			
			pw.println(buffer.toString());
			buffer.delete(0, buffer.toString().length());
		}
		
		pw.close();
		
		return new FileInputStream(path);
	}
}
