package com.jm.gen;

public class StdLib {
	public static final int BUFFLEN = 256;

	public static int strlen(char[] str){
		for (int i = 0; i < str.length; i++){
			if (str[i] == 0){
				return i;
			}
		}
		return -1;
	}
	
	public static boolean isalpha(char c){
		return ('a' <= c && c <= 'z') || ('A' <= c && c <= 'Z');
	}
	
	public static boolean isnumber(char c){
		return '0' <= c && c <= '9';
	}
	
	public static int tolower(char c){
		return ('A' <= c && c <= 'Z')? 'a' + (c - 'A') : c;
	}
	
	public static void strcpy(char[] dst, char[] src){
		strcpy(dst, src, 0);
	}
	
	public static void strcpy(char[] dst, char[] src, int off){
		int i;
		for (i = 0; src[off + i] != '\0'; i++){
			dst[i] = src[off + i];
		}
		dst[i] = '\0';
	}
	
	public static void strcat(char[] dst, char[] src){
		strcat(dst, src, 0);
	}
	
	public static void strcat(char[] dst, char[] src, int off){
		int i;
		for (i = 0; dst[i] != '\0'; i++){
			;
		}
		for (int j = 0; src[off + j] != '\0'; i++, j++){
			dst[i] = src[off + j];
		}
		dst[i] = '\0';
	}
	
	public static int strstr(char[] s1, int off, char[] s2) {
		int i1 = 0;
		int i2 = 0;

		while (s1[off + i1] != '\0' && s2[i2] != '\0') {
			if (s1[off + i1] == s2[i2]) {
				i1++;
				i2++;
			} else {
				// p1 -= p2 - s2 -1;
				// p2 = s2;
				i1 -= i2 - 1;
				i2 = 0;
			}
		}
		// return (*p2 ? NULL : (char *)(p1 - (p2 -s2)));
		return (s2[i2] != '\0')? -1 : off + i1 - i2;
	}

	public static int atoi(char[] src){
		return atoi(src, 0);
	}
	
	public static int atoi(char[] src, int off){
		int i;
		int n = 0;
		
		for (i = 0; isnumber(src[off + i]); i++){
			n *= 10;
			n += src[off + i] - '0';
		}
		return n;
	}
	
	public static int HIWORD(int n){
		return n >> 16;
	}
	
	public static int LOWORD(int n){
		return n & 0x0000ffff;
	}
	
	public static int MAKELONG(int h, int l){
		return (l << 16) + (h & 0x0000ffff);
	}
	
	public static boolean toBoolean(int n) {
		return n != 0;
	}

	public static int toInt(boolean b) {
		return (b) ? 1 : 0;
	}

	public static char[] stoc(String str){
		byte[] b = str.getBytes();
		char[] c = new char[b.length + 1];
		
		int i;
		for (i = 0; i < b.length; i++){
			c[i] = (char) b[i];
		}
		c[i] = '\0';
		
		return c;
	}
	
	public static String ctos(char[] c){
		byte[] b = new byte[strlen(c)];
		for (int i = 0; i < b.length; i++){
			b[i] = (byte)c[i];
		}
		return new String(b);
	}
	
	public static void wsprintf(char[] dst, int n){
		int i = 0;
		
		dst[i++] = ' ';
		dst[i++] = (char)((n % 100) / 10);
		dst[i++] = (char)(n % 10);
		dst[i++] = ' ';
	}

	public static int ctod(char c) {
		return ((c) >= '0' && (c) <= '9') ? (c) - '0' : (c) - 'a' + 10;
	}

	public static char dtoc(int i) {
		return (char) (((i) >= 0 && (i) <= 9) ? ((i) + '0') : ((i) - 10 + 'a'));
	}
}
