/*
 * Decompiled with CFR 0.152.
 */
package com.kurukurupapa.tryandroid.fw.apt;

import com.kurukurupapa.tryandroid.fw.apt.AptUtils;
import com.kurukurupapa.tryandroid.fw.apt.TaaExclude;
import com.kurukurupapa.tryandroid.fw.apt.TableData;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Properties;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;

public class DaoGenerater {
    public void generateSource(Element element, ProcessingEnvironment processingEnv) {
        PrintWriter writer = null;
        try {
            try {
                TableData data = this.getData(element, processingEnv);
                JavaFileObject file = AptUtils.createSourceFile(data.getDestClassName(), processingEnv);
                writer = new PrintWriter(file.openWriter(), true);
                this.writeClass(writer, data);
                writer.flush();
            }
            catch (Exception e) {
                Messager messager = processingEnv.getMessager();
                messager.printMessage(Diagnostic.Kind.ERROR, e.toString());
                throw new RuntimeException(e);
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    private TableData getData(Element classElement, ProcessingEnvironment processingEnv) {
        TableData data = new TableData();
        String packageName = AptUtils.getPackageName(classElement, processingEnv);
        data.setSrcPackageName(packageName);
        data.setSrcSimpleName(classElement.getSimpleName().toString());
        data.setDestPackageName(packageName);
        data.setDestSimpleName(String.valueOf(data.getSrcSimpleName()) + "Dao");
        for (Element element : classElement.getEnclosedElements()) {
            if (element.getKind() != ElementKind.FIELD || element.getAnnotation(TaaExclude.class) != null) continue;
            String type = element.asType().toString();
            String name = element.getSimpleName().toString();
            data.addField(type, name, element);
        }
        return data;
    }

    private void writeClass(PrintWriter w, TableData data) throws Exception {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream("velocity.properties");
        if (is == null) {
            throw new RuntimeException("Velocity\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f\u3002URL=" + this.getClass().getClassLoader().getResource("velocity.properties"));
        }
        Properties props = new Properties();
        props.load(is);
        Velocity.init((Properties)props);
        VelocityContext context = new VelocityContext();
        context.put("data", (Object)data);
        Template template = Velocity.getTemplate((String)"Dao.vm", (String)"UTF-8");
        template.merge((Context)context, (Writer)w);
    }
}

