package com.kurukurupapa.tryandroidui.draglist;


import android.app.Activity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TwoLineListItem;

/**
 * ドラッグアンドドロップで並び替え可能なリストビュー用のデータアダプター（リスト項目は２つのテキスト）
 */
public class DragListTwoItemAdapter extends DragListAdapter {
	private Activity mActivity;
	private String[][] mItems;

	public DragListTwoItemAdapter(String[][] items, Activity activity) {
		mItems = items;
		mActivity = activity;
	}

	@Override
	public int getCount() {
		return mItems.length;
	}

	@Override
	public Object getItem(int position) {
		return mItems[position];
	}

	@Override
	public long getItemId(int position) {
		return position;
	}

	@Override
	public View getView(int position, View convertView, ViewGroup parent) {
		String[] data = mItems[position];

		if (convertView == null) {
			convertView = mActivity.getLayoutInflater().inflate(
					android.R.layout.simple_list_item_2, null);
		}

		TwoLineListItem view = (TwoLineListItem) convertView;
		view.getText1().setText(data[0]);
		view.getText2().setText(data[1]);

		return super.getView(position, convertView, parent);
	}

	@Override
	public void swapItems(int position1, int position2) {
		String[] tmp = mItems[position1];
		mItems[position1] = mItems[position2];
		mItems[position2] = tmp;
	}

	@Override
	protected View getNormalView(int position, View convertView,
			ViewGroup parent) {
		// TODO 自動生成されたメソッド・スタブ
		return null;
	}

}
