package com.kurukurupapa.tryandroidui.draglist2;

import com.kurukurupapa.tryandroidui.R;
import com.kurukurupapa.tryandroidui.draglist.DragListListener;

import android.app.Activity;
import android.os.Bundle;

/**
 * ドラッグアンドドロップで並び替え可能なリストビューを表示するサンプル２
 *
 * 元ネタ<br>
 * ドラッグ＆ドロップで並び替えできる ListView - へたれプログラマの備忘録
 * http://d.hatena.ne.jp/shogo0809/20110118/1295326773
 */
public class DragList2Activity extends Activity {
	private String[][] mItems = { { "Android 1.0（APIレベル1）", "" },
			{ "Android 1.1（APIレベル2）", "" },
			{ "Android 1.5（APIレベル3）", "Cupcake（カップケーキ）" },
			{ "Android 1.6（APIレベル4）", "Donut（ドーナツ）" },
			{ "Android 2.0（APIレベル5）", "Eclair（エクレア）" },
			{ "Android 2.0.1（APIレベル6）", "Eclair（エクレア）" },
			{ "Android 2.1（APIレベル7）", "Eclair（エクレア）" },
			{ "Android 2.2（APIレベル8）", "Froyo(Frozen Yogurt)（フローズンヨーグルト）" },
			{ "Android 2.3（APIレベル9）", "Gingerbread（ジンジャーブレッド）" },
			{ "Android 2.3.3（APIレベル10）", "Gingerbread（ジンジャーブレッド）" },
			{ "Android 3.0（APIレベル11）", "Honeycomb（蜂の巣）" },
			{ "Android 3.1（APIレベル12）", "Honeycomb（蜂の巣）" },
			{ "Android 3.2（APIレベル13）", "Honeycomb（蜂の巣）" },
			{ "Android 4.0（APIレベル14）", "Ice Cream Sandwich（アイスクリームサンドイッチ）" }, };

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);

		setContentView(R.layout.drag_list_view2);

		DragList2Adapter adapter = new DragList2Adapter(mItems, this);
		DragList2View listView = (DragList2View) findViewById(R.id.list);
		listView.setDragListener(new DragListListener(adapter));
		listView.setAdapter(adapter);
	}

}
