/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.util.collection;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Array;
import org.seasar.util.exception.SNoSuchElementException;
import org.seasar.util.misc.AssertionUtil;

public class SLinkedList<E>
implements Cloneable,
Externalizable {
    static final long serialVersionUID = 1L;
    private transient Entry header = new Entry(null, null, null);
    private transient int size = 0;

    public SLinkedList() {
        this.header.next = this.header;
        this.header.previous = this.header;
    }

    public E getFirst() {
        if (this.isEmpty()) {
            throw new SNoSuchElementException();
        }
        return this.getFirstEntry().element;
    }

    public E getLast() {
        if (this.isEmpty()) {
            throw new SNoSuchElementException();
        }
        return this.getLastEntry().element;
    }

    public Entry getFirstEntry() {
        if (this.isEmpty()) {
            return null;
        }
        return this.header.next;
    }

    public Entry getLastEntry() {
        if (this.isEmpty()) {
            return null;
        }
        return this.header.previous;
    }

    public E removeFirst() {
        if (this.isEmpty()) {
            throw new SNoSuchElementException();
        }
        Object first = this.header.next.element;
        this.header.next.remove();
        return first;
    }

    public E removeLast() {
        if (this.isEmpty()) {
            throw new SNoSuchElementException();
        }
        Object last = this.header.previous.element;
        this.header.previous.remove();
        return last;
    }

    public void addFirst(E element) {
        this.header.next.addBefore(element);
    }

    public void addLast(E element) {
        this.header.addBefore(element);
    }

    public void add(int index, E element) {
        this.getEntry(index).addBefore(element);
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean contains(E element) {
        return this.indexOf(element) != -1;
    }

    public boolean remove(E element) {
        if (element == null) {
            Entry e = this.header.next;
            while (e != this.header) {
                if (e.element == null) {
                    e.remove();
                    return true;
                }
                e = e.next;
            }
        } else {
            Entry e = this.header.next;
            while (e != this.header) {
                if (element.equals(e.element)) {
                    e.remove();
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public Object remove(int index) {
        Entry e = this.getEntry(index);
        e.remove();
        return e.element;
    }

    public void clear() {
        this.header.next = this.header;
        this.header.previous = this.header;
        this.size = 0;
    }

    public Entry getEntry(int index) {
        AssertionUtil.assertIndex(0 <= index && index < this.size, "Index: " + index + ", Size: " + this.size);
        Entry e = this.header;
        if (index < this.size / 2) {
            for (int i = 0; i <= index; ++i) {
                e = e.next;
            }
        } else {
            for (int i = this.size; i > index; --i) {
                e = e.previous;
            }
        }
        return e;
    }

    public E get(int index) {
        return this.getEntry((int)index).element;
    }

    public E set(int index, E element) {
        Entry entry = this.getEntry(index);
        Object oldValue = entry.element;
        entry.element = element;
        return oldValue;
    }

    public int indexOf(E element) {
        int index = 0;
        if (element == null) {
            Entry e = this.header.next;
            while (e != this.header) {
                if (e.element == null) {
                    return index;
                }
                ++index;
                e = e.next;
            }
        } else {
            Entry e = this.header.next;
            while (e != this.header) {
                if (element.equals(e.element)) {
                    return index;
                }
                ++index;
                e = e.next;
            }
        }
        return -1;
    }

    @Override
    public void writeExternal(ObjectOutput s) throws IOException {
        s.writeInt(this.size);
        Entry e = this.header.next;
        while (e != this.header) {
            s.writeObject(e.element);
            e = e.next;
        }
    }

    @Override
    public void readExternal(ObjectInput s) throws IOException, ClassNotFoundException {
        int size = s.readInt();
        this.header.next = this.header = new Entry(null, null, null);
        this.header.previous = this.header;
        for (int i = 0; i < size; ++i) {
            this.addLast(s.readObject());
        }
    }

    public Object clone() {
        SLinkedList copy = new SLinkedList();
        Entry e = this.header.next;
        while (e != this.header) {
            copy.addLast(e.element);
            e = e.next;
        }
        return copy;
    }

    public Object[] toArray() {
        Object[] result = new Object[this.size];
        int i = 0;
        Entry e = this.header.next;
        while (e != this.header) {
            result[i++] = e.element;
            e = e.next;
        }
        return result;
    }

    public E[] toArray(E[] array) {
        if (array.length < this.size) {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), this.size);
        }
        int i = 0;
        Entry e = this.header.next;
        while (e != this.header) {
            array[i++] = e.element;
            e = e.next;
        }
        for (i = this.size; i < array.length; ++i) {
            array[i] = null;
        }
        return array;
    }

    public class Entry {
        protected E element;
        protected Entry next;
        protected Entry previous;

        Entry(E element, Entry next, Entry previous) {
            this.element = element;
            this.next = next;
            this.previous = previous;
        }

        public E getElement() {
            return this.element;
        }

        public Entry getNext() {
            if (this.next != SLinkedList.this.header) {
                return this.next;
            }
            return null;
        }

        public Entry getPrevious() {
            if (this.previous != SLinkedList.this.header) {
                return this.previous;
            }
            return null;
        }

        public void remove() {
            this.previous.next = this.next;
            this.next.previous = this.previous;
            --SLinkedList.this.size;
        }

        public Entry addBefore(E o) {
            Entry newEntry;
            this.previous.next = newEntry = new Entry(o, this, this.previous);
            this.previous = newEntry;
            ++SLinkedList.this.size;
            return newEntry;
        }
    }
}

