package com.kurukurupapa.tryandroidui.expandablelistview;

import android.view.Gravity;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.ViewGroup;
import android.view.ViewGroup.LayoutParams;
import android.widget.AbsListView;
import android.widget.BaseExpandableListAdapter;
import android.widget.TextView;

public class MyExpandableListAdapter extends BaseExpandableListAdapter
		implements OnClickListener {

	private String[][] data = new String[][] {
			{ "Child1-1", "Child1-2", "Child1-3" },
			{ "Child2-1", "Child2-2", "Child2-3", "Child2-4" },
			{ "Child3-1", "Child3-2" },
			{ "※グループの高さやインデント、縦・横寄せは、プログラム側で自由に設定可能です。", //
					"※各項目の高さやインデント、縦・横寄せは、プログラム側で自由に設定可能です。", //
					"クリックすると高さが変わります。" } };

	private static final int BIG_GROUP_INDEX = 3;
	private static final int CHILD_DEFAULT_HEIGHT = 32;

	@Override
	public int getGroupCount() {
		return data.length;
	}

	@Override
	public int getChildrenCount(int groupPosition) {
		return data[groupPosition].length;
	}

	@Override
	public Object getGroup(int groupPosition) {
		return data[groupPosition];
	}

	@Override
	public Object getChild(int groupPosition, int childPosition) {
		return data[groupPosition][childPosition];
	}

	@Override
	public long getGroupId(int groupPosition) {
		// グループを識別するIDを返却する。
		return groupPosition;
	}

	@Override
	public long getChildId(int groupPosition, int childPosition) {
		// 引数のグループ内で、子要素を識別するIDを返却する。
		return childPosition;
	}

	@Override
	public View getGroupView(int groupPosition, boolean isExpanded,
			View convertView, ViewGroup parent) {
		String[] data = (String[]) getGroup(groupPosition);

		// グループのオブジェクトを作成する
		int height = 64;
		int indent = 36;
		if (groupPosition == BIG_GROUP_INDEX) {
			height *= 1.5;
			indent *= 1.5;
		}
		TextView view = new TextView(parent.getContext());
		// 高さは、矢印アイコン分を確保しておく
		view.setLayoutParams(new AbsListView.LayoutParams(
				LayoutParams.FILL_PARENT, height));
		// テキストの左位置は、矢印アイコンに重ならないようにする
		view.setPadding(indent, 0, 0, 0);
		// 縦方向に中央、横方向に左寄せ
		view.setGravity(Gravity.CENTER_VERTICAL | Gravity.LEFT);
		// テキスト設定
		view.setText("Group " + groupPosition + " (" + data.length + ")");

		return view;
	}

	@Override
	public View getChildView(int groupPosition, int childPosition,
			boolean isLastChild, View convertView, ViewGroup parent) {
		String data = (String) getChild(groupPosition, childPosition);

		// 項目のオブジェクトを作成する
		int height = CHILD_DEFAULT_HEIGHT;
		int indent = 36 + 18;
		if (groupPosition == BIG_GROUP_INDEX) {
			height *= (childPosition + 1);
			indent *= (childPosition + 1);
		}
		TextView view = new TextView(parent.getContext());
		// 高さには余裕をもたせる。あまり狭いと、選択状態表示が変に見えてしまう。
		view.setLayoutParams(new AbsListView.LayoutParams(
				LayoutParams.FILL_PARENT, height));
		// お好みで、グループのViewに合わせて、インデントを付ける。
		view.setPadding(indent, 0, 0, 0);
		// 縦方向に中央、横方向に左寄せ
		view.setGravity(Gravity.CENTER_VERTICAL | Gravity.LEFT);
		// テキスト設定
		view.setText(data);

		if (groupPosition == BIG_GROUP_INDEX) {
			view.setOnClickListener(this);
		}

		return view;
	}

	@Override
	public boolean hasStableIds() {
		return true;
	}

	@Override
	public boolean isChildSelectable(int groupPosition, int childPosition) {
		// 子要素を選択可能にする
		return true;
	}

	@Override
	public void onClick(View view) {
		int height = view.getHeight();
		height += CHILD_DEFAULT_HEIGHT;
		if (height > 100) {
			height = CHILD_DEFAULT_HEIGHT;
		}
		view.setLayoutParams(new AbsListView.LayoutParams(
				LayoutParams.FILL_PARENT, height));
	}
}
