package com.tryandroid;

import java.util.ArrayList;

import android.content.Intent;

/**
 * メイン画面へリスト表示するデータを保持するクラス
 */
public class MapList extends ArrayList<ItemMap> {
	/**
	 * シリアルバージョンID
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * データ追加
	 *
	 * @param text
	 *            画面表示の文字列
	 * @param intent
	 *            ユーザが当データを選択したときに遷移する画面
	 * @param requestCode
	 *            遷移先画面のリクエストコード（未使用）
	 */
	public void add(String text, Intent intent, int requestCode) {
		add(new ItemMap(text, intent, requestCode));
	}

	public void add(String text, Intent intent) {
		add(new ItemMap(text, intent, 0));
	}

	public String getTextKey() {
		return ItemMap.KEY_TEXT;
	}
}
