package com.tryandroid.battery;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;

import com.tryandroid.R;

import android.content.Context;
import android.content.Intent;
import android.os.BatteryManager;

public class BatteryData {
	private Context context;

	public Calendar calendar = new GregorianCalendar();
	public boolean present;
	public int level;
	public int scale;
	public int icon_small;
	public int voltage;
	public int temperature;
	public String technology;
	public String statusString = "";
	public String healthString = "";
	public String pluggedString = "";

	public BatteryData(Context context) {
		this.context = context;
	}

	public void onReceive(Context context, Intent intent) {
		String action = intent.getAction();
		if (!action.equals(Intent.ACTION_BATTERY_CHANGED)) {
			return;
		}
		calendar = GregorianCalendar.getInstance();
		statusString = getStatusString(intent.getIntExtra("status", 0));
		healthString = getHealthString(intent.getIntExtra("health", 0));
		present = intent.getBooleanExtra("present", false);
		level = intent.getIntExtra("level", 0);
		scale = intent.getIntExtra("scale", 0);
		icon_small = intent.getIntExtra("icon-small", 0);
		pluggedString = getPluggedString(intent.getIntExtra("plugged", 0));
		voltage = intent.getIntExtra("voltage", 0);
		temperature = intent.getIntExtra("temperature", 0);
		technology = intent.getStringExtra("technology");
	}

	private String getStatusString(int status) {
		String str = "";
		switch (status) {
		case BatteryManager.BATTERY_STATUS_UNKNOWN:
			str = "unknown";
			break;
		case BatteryManager.BATTERY_STATUS_CHARGING:
			str = "charging";
			break;
		case BatteryManager.BATTERY_STATUS_DISCHARGING:
			str = "discharging";
			break;
		case BatteryManager.BATTERY_STATUS_NOT_CHARGING:
			str = "not charging";
			break;
		case BatteryManager.BATTERY_STATUS_FULL:
			str = "full";
			break;
		}
		return str;
	}

	private String getHealthString(int health) {
		String str = "";
		switch (health) {
		case BatteryManager.BATTERY_HEALTH_UNKNOWN:
			str = "unknown";
			break;
		case BatteryManager.BATTERY_HEALTH_GOOD:
			str = "good";
			break;
		case BatteryManager.BATTERY_HEALTH_OVERHEAT:
			str = "overheat";
			break;
		case BatteryManager.BATTERY_HEALTH_DEAD:
			str = "dead";
			break;
		case BatteryManager.BATTERY_HEALTH_OVER_VOLTAGE:
			str = "voltage";
			break;
		case BatteryManager.BATTERY_HEALTH_UNSPECIFIED_FAILURE:
			str = "unspecified failure";
			break;
		}
		return str;
	}

	private String getPluggedString(int plugged) {
		String str = "not plugged";
		switch (plugged) {
		case BatteryManager.BATTERY_PLUGGED_AC:
			str = "AC";
			break;
		case BatteryManager.BATTERY_PLUGGED_USB:
			str = "USB";
			break;
		}
		return str;
	}

	public Map<String, String> getKeyValueMap() {
		SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");

		Map<String, String> map = new HashMap<String, String>();
		map.put(getText(R.string.battery_timestamp), format.format(calendar
				.getTime()));
		map.put(getText(R.string.battery_status), statusString);
		map.put(getText(R.string.battery_health), healthString);
		map.put(getText(R.string.battery_present), String.valueOf(present));
		map.put(getText(R.string.battery_level), String.valueOf(level) + " ("
				+ String.valueOf(Math.round(100 * level / scale)) + "%)");
		map.put(getText(R.string.battery_scale), String.valueOf(scale));
		map.put(getText(R.string.battery_icon_small), String
				.valueOf(icon_small));
		map.put(getText(R.string.battery_plugged), pluggedString);
		map.put(getText(R.string.battery_voltage), String.valueOf(voltage)
				+ " mV");
		map.put(getText(R.string.battery_temperature), String.valueOf(Math
				.round(temperature / 10))
				+ " " + getText(R.string.battery_temperature_unit));
		map.put(getText(R.string.battery_technology), technology);
		return map;
	}

	private String getText(int id) {
		return context.getText(id).toString();
	}
}
