package com.tryandroid.sensor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.tryandroid.R;

import android.app.Activity;
import android.hardware.Sensor;
import android.hardware.SensorManager;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.ListView;
import android.widget.RadioButton;
import android.widget.SimpleAdapter;

public class SensorActivity extends Activity {
	protected static final String ITEM = "Item";
	protected static final String VALUE = "Value";
	private static final int ELEMENT_COUNT = 50;

	private SensorManager sensorManager;
	private AccelerometerSensorListener accelerometerListener;
	private OrientationSensorListener orientationListener;

	/** Called when the activity is first created. */
	@Override
	public void onCreate(Bundle savedInstanceState) {
		Log.d(getClass().getName(), "onCreate Called");
		super.onCreate(savedInstanceState);
		setContentView(R.layout.sensor);

		// SensorManager取得
		sensorManager = (SensorManager) getSystemService(SENSOR_SERVICE);

		// フィルターラジオボタン
		RadioButton noFilterButton = (RadioButton) findViewById(R.id.sensor_no_filter_button);
		noFilterButton.setChecked(true);
		noFilterButton.setOnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View v) {
				accelerometerListener
						.setFilter(BaseSensorEventListener.NO_FILTER);
				orientationListener
						.setFilter(BaseSensorEventListener.NO_FILTER);
			}
		});
		RadioButton lowFilterButton = (RadioButton) findViewById(R.id.sensor_low_filter_button);
		lowFilterButton.setOnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View v) {
				accelerometerListener
						.setFilter(BaseSensorEventListener.LOW_PASS_FILTER);
				orientationListener
						.setFilter(BaseSensorEventListener.LOW_PASS_FILTER);
			}
		});
		RadioButton highFilterButton = (RadioButton) findViewById(R.id.sensor_high_filter_button);
		highFilterButton.setOnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View v) {
				accelerometerListener
						.setFilter(BaseSensorEventListener.HIGH_PASS_FILTER);
				orientationListener
						.setFilter(BaseSensorEventListener.HIGH_PASS_FILTER);
			}
		});

	}

	@Override
	protected void onResume() {
		Log.d(getClass().getName(), "onResume Called");
		super.onResume();

		// フィルターラジオボタン
		RadioButton noFilterButton = (RadioButton) findViewById(R.id.sensor_no_filter_button);
		noFilterButton.setChecked(true);

		// 加速度センサーリスナー登録
		accelerometerListener = new AccelerometerSensorListener(this,
				ELEMENT_COUNT);
		sensorManager.registerListener(accelerometerListener, sensorManager
				.getDefaultSensor(Sensor.TYPE_ACCELEROMETER),
				SensorManager.SENSOR_DELAY_NORMAL);
		// 傾きセンサーリスナー登録
		orientationListener = new OrientationSensorListener(this, ELEMENT_COUNT);
		sensorManager.registerListener(orientationListener, sensorManager
				.getDefaultSensor(Sensor.TYPE_ORIENTATION),
				SensorManager.SENSOR_DELAY_NORMAL);
	}

	@Override
	protected void onPause() {
		Log.d(getClass().getName(), "onPause Called");
		super.onPause();

		// 加速度センサーリスナー削除
		sensorManager.unregisterListener(accelerometerListener);
		// 傾きセンサーリスナー削除
		sensorManager.unregisterListener(orientationListener);
	}

	public void update() {
		Log.d(getClass().getName(), "update Called");

		List<Map<String, String>> data = new ArrayList<Map<String, String>>();

		// 加速度センサー
		data.add(createMap(accelerometerListener.getName(),
				accelerometerListener.getResult()));
		// 傾きセンサー
		data.add(createMap(orientationListener.getName(), orientationListener
				.getResult()));

		ListView listView = (ListView) findViewById(R.id.sensor_list_view);
		listView.setAdapter(new SimpleAdapter(this, data,
				android.R.layout.simple_list_item_2,
				new String[] { ITEM, VALUE }, new int[] { android.R.id.text1,
						android.R.id.text2 }));
	}

	private Map<String, String> createMap(String item, String value) {
		Map<String, String> map = new HashMap<String, String>();
		map.put(ITEM, item);
		map.put(VALUE, value);
		return map;
	}
}