/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.aptina.commons.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.lang.model.element.Modifier;

public class ModifierUtils {
    public static final Set<Modifier> ACCESS_MODIFIERS;

    private ModifierUtils() {
    }

    public static boolean isDefault(Set<Modifier> modifiers) {
        return Collections.disjoint(modifiers, ACCESS_MODIFIERS);
    }

    public static String toStringOfModifiers(Set<Modifier> modifiers) {
        if (modifiers.isEmpty()) {
            return "";
        }
        StringBuilder buf = new StringBuilder(32);
        if (modifiers.contains((Object)Modifier.PUBLIC)) {
            buf.append("public ");
        }
        if (modifiers.contains((Object)Modifier.PROTECTED)) {
            buf.append("protected ");
        }
        if (modifiers.contains((Object)Modifier.PRIVATE)) {
            buf.append("private ");
        }
        if (modifiers.contains((Object)Modifier.ABSTRACT)) {
            buf.append("abstract ");
        }
        if (modifiers.contains((Object)Modifier.STATIC)) {
            buf.append("static ");
        }
        if (modifiers.contains((Object)Modifier.FINAL)) {
            buf.append("final ");
        }
        if (modifiers.contains((Object)Modifier.TRANSIENT)) {
            buf.append("transient ");
        }
        if (modifiers.contains((Object)Modifier.VOLATILE)) {
            buf.append("volatile ");
        }
        if (modifiers.contains((Object)Modifier.SYNCHRONIZED)) {
            buf.append("synchronized ");
        }
        if (modifiers.contains((Object)Modifier.NATIVE)) {
            buf.append("native ");
        }
        if (modifiers.contains((Object)Modifier.STRICTFP)) {
            buf.append("strictfp ");
        }
        return new String(buf);
    }

    static {
        HashSet<Modifier> set = new HashSet<Modifier>();
        set.add(Modifier.PUBLIC);
        set.add(Modifier.PROTECTED);
        set.add(Modifier.PRIVATE);
        ACCESS_MODIFIERS = Collections.unmodifiableSet(set);
    }
}

