/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.aptina.commons.util;

import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.seasar.aptina.commons.util.IOUtils;

public class VersionUtils {
    private static final String POM_PROPERTIES_NAME = "META-INF/maven/%1$s/%2$s/pom.properties";

    private VersionUtils() {
    }

    public static String getVersion(String groupId, String artifactId) {
        return VersionUtils.getVersion(groupId, artifactId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getVersion(String groupId, String artifactId, String defaultValue) {
        String string;
        String name = String.format(POM_PROPERTIES_NAME, groupId, artifactId);
        URL url = Thread.currentThread().getContextClassLoader().getResource(name);
        if (url == null) {
            return defaultValue;
        }
        InputStream is = url.openStream();
        try {
            Properties props = new Properties();
            props.load(is);
            string = props.getProperty("version");
        }
        catch (Throwable throwable) {
            try {
                IOUtils.closeSilently(is);
                throw throwable;
            }
            catch (Exception e) {
                return defaultValue;
            }
        }
        IOUtils.closeSilently(is);
        return string;
    }
}

