/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.util.beans.impl;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import org.seasar.util.beans.BeanDesc;
import org.seasar.util.beans.MethodDesc;
import org.seasar.util.beans.ParameterizedClassDesc;
import org.seasar.util.beans.factory.ParameterizedClassDescFactory;
import org.seasar.util.exception.MethodNotStaticRuntimeException;
import org.seasar.util.lang.MethodUtil;
import org.seasar.util.misc.AssertionUtil;

public class MethodDescImpl
implements MethodDesc {
    protected final BeanDesc beanDesc;
    protected final Method method;
    protected final String methodName;
    protected final Class<?>[] parameterTypes;
    protected final Class<?> returnType;
    protected final ParameterizedClassDesc[] parameterizedClassDescs;
    protected final ParameterizedClassDesc parameterizedClassDesc;

    public MethodDescImpl(BeanDesc beanDesc, Method method) {
        AssertionUtil.assertArgumentNotNull("beanDesc", beanDesc);
        AssertionUtil.assertArgumentNotNull("method", method);
        this.beanDesc = beanDesc;
        this.method = method;
        this.methodName = method.getName();
        this.parameterTypes = method.getParameterTypes();
        this.returnType = method.getReturnType();
        this.parameterizedClassDescs = new ParameterizedClassDesc[this.parameterTypes.length];
        for (int i = 0; i < this.parameterTypes.length; ++i) {
            this.parameterizedClassDescs[i] = ParameterizedClassDescFactory.createParameterizedClassDesc(method, i, beanDesc.getTypeVariables());
        }
        this.parameterizedClassDesc = ParameterizedClassDescFactory.createParameterizedClassDesc(method, beanDesc.getTypeVariables());
    }

    @Override
    public BeanDesc getBeanDesc() {
        return this.beanDesc;
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    @Override
    public String getMethodName() {
        return this.methodName;
    }

    @Override
    public Class<?>[] getParameterTypes() {
        return this.parameterTypes;
    }

    @Override
    public <T> Class<T> getReturnType() {
        return this.returnType;
    }

    @Override
    public boolean isPublic() {
        return MethodUtil.isPublic(this.method);
    }

    @Override
    public boolean isStatic() {
        return MethodUtil.isStatic(this.method);
    }

    @Override
    public boolean isFinal() {
        return MethodUtil.isFinal(this.method);
    }

    @Override
    public boolean isAbstract() {
        return MethodUtil.isAbstract(this.method);
    }

    @Override
    public boolean isParameterized(int index) {
        AssertionUtil.assertArgumentArrayIndex("index", index, this.parameterTypes.length);
        return this.parameterizedClassDescs[index].isParameterizedClass();
    }

    @Override
    public boolean isParameterized() {
        return this.parameterizedClassDesc.isParameterizedClass();
    }

    @Override
    public ParameterizedClassDesc[] getParameterizedClassDescs() {
        return this.parameterizedClassDescs;
    }

    @Override
    public ParameterizedClassDesc getParameterizedClassDesc() {
        return this.parameterizedClassDesc;
    }

    @Override
    public Class<?> getElementClassOfCollection(int index) {
        AssertionUtil.assertArgumentArrayIndex("index", index, this.parameterTypes.length);
        if (!Collection.class.isAssignableFrom(this.parameterTypes[index]) || !this.isParameterized(index)) {
            return null;
        }
        ParameterizedClassDesc pcd = this.parameterizedClassDescs[index].getArguments()[0];
        if (pcd == null) {
            return null;
        }
        return pcd.getRawClass();
    }

    @Override
    public Class<?> getKeyClassOfMap(int index) {
        AssertionUtil.assertArgumentArrayIndex("index", index, this.parameterTypes.length);
        if (!Map.class.isAssignableFrom(this.parameterTypes[index]) || !this.isParameterized(index)) {
            return null;
        }
        ParameterizedClassDesc pcd = this.parameterizedClassDescs[index].getArguments()[0];
        if (pcd == null) {
            return null;
        }
        return pcd.getRawClass();
    }

    @Override
    public Class<?> getValueClassOfMap(int index) {
        AssertionUtil.assertArgumentArrayIndex("index", index, this.parameterTypes.length);
        if (!Map.class.isAssignableFrom(this.parameterTypes[index]) || !this.isParameterized(index)) {
            return null;
        }
        ParameterizedClassDesc pcd = this.parameterizedClassDescs[index].getArguments()[1];
        if (pcd == null) {
            return null;
        }
        return pcd.getRawClass();
    }

    @Override
    public Class<?> getElementClassOfCollection() {
        if (!Collection.class.isAssignableFrom(this.returnType) || !this.isParameterized()) {
            return null;
        }
        ParameterizedClassDesc pcd = this.parameterizedClassDesc.getArguments()[0];
        if (pcd == null) {
            return null;
        }
        return pcd.getRawClass();
    }

    @Override
    public Class<?> getKeyClassOfMap() {
        if (!Map.class.isAssignableFrom(this.returnType) || !this.isParameterized()) {
            return null;
        }
        ParameterizedClassDesc pcd = this.parameterizedClassDesc.getArguments()[0];
        if (pcd == null) {
            return null;
        }
        return pcd.getRawClass();
    }

    @Override
    public Class<?> getValueClassOfMap() {
        if (!Map.class.isAssignableFrom(this.returnType) || !this.isParameterized()) {
            return null;
        }
        ParameterizedClassDesc pcd = this.parameterizedClassDesc.getArguments()[1];
        if (pcd == null) {
            return null;
        }
        return pcd.getRawClass();
    }

    @Override
    public <T> T invoke(Object target, Object ... args) {
        AssertionUtil.assertArgumentNotNull("target", target);
        return MethodUtil.invoke(this.method, target, args);
    }

    @Override
    public <T> T invokeStatic(Object ... args) {
        if (!this.isStatic()) {
            throw new MethodNotStaticRuntimeException(this.getBeanDesc().getBeanClass(), this.methodName);
        }
        return MethodUtil.invokeStatic(this.method, args);
    }
}

