/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.util.collection;

import java.util.Enumeration;
import java.util.Iterator;
import org.seasar.util.exception.SUnsupportedOperationException;
import org.seasar.util.misc.AssertionUtil;

public class EnumerationIterator<T>
implements Iterator<T> {
    private Enumeration<T> enumeration = null;

    public static <T> Iterable<T> iterable(final Enumeration<T> enumeration) {
        AssertionUtil.assertArgumentNotNull("enumeration", enumeration);
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new EnumerationIterator(enumeration);
            }
        };
    }

    public EnumerationIterator(Enumeration<T> enumeration) {
        AssertionUtil.assertArgumentNotNull("enumeration", enumeration);
        this.enumeration = enumeration;
    }

    @Override
    public void remove() {
        throw new SUnsupportedOperationException("remove");
    }

    @Override
    public boolean hasNext() {
        return this.enumeration.hasMoreElements();
    }

    @Override
    public T next() {
        return this.enumeration.nextElement();
    }
}

