/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.util.collection;

import java.util.Iterator;
import org.seasar.util.exception.SNoSuchElementException;
import org.seasar.util.exception.SUnsupportedOperationException;

public class SingleValueIterator<E>
implements Iterator<E> {
    protected final E value;
    protected boolean hasNext = true;

    public static <E> Iterable<E> iterable(final E value) {
        return new Iterable<E>(){

            @Override
            public Iterator<E> iterator() {
                return new SingleValueIterator<Object>(value);
            }
        };
    }

    public SingleValueIterator(E value) {
        this.value = value;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public E next() {
        if (!this.hasNext) {
            throw new SNoSuchElementException();
        }
        this.hasNext = false;
        return this.value;
    }

    @Override
    public void remove() {
        throw new SUnsupportedOperationException("remove");
    }
}

