/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.util.security;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.seasar.util.exception.NoSuchAlgorithmRuntimeException;
import org.seasar.util.exception.SIllegalStateException;
import org.seasar.util.misc.AssertionUtil;

public abstract class MessageDigestUtil {
    public static MessageDigest getInstance(String algorithm) {
        AssertionUtil.assertArgumentNotEmpty("algorithm", algorithm);
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new NoSuchAlgorithmRuntimeException(e);
        }
    }

    public static String digest(String algorithm, String text) {
        AssertionUtil.assertArgumentNotEmpty("algorithm", algorithm);
        if (text == null) {
            return null;
        }
        MessageDigest msgDigest = MessageDigestUtil.getInstance(algorithm);
        try {
            msgDigest.update(text.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new SIllegalStateException(e);
        }
        byte[] digest = msgDigest.digest();
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < digest.length; ++i) {
            String tmp = Integer.toHexString(digest[i] & 0xFF);
            if (tmp.length() == 1) {
                buffer.append('0').append(tmp);
                continue;
            }
            buffer.append(tmp);
        }
        return buffer.toString();
    }
}

