/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.aptina.unit;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import junit.framework.ComparisonFailure;
import junit.framework.TestCase;
import org.seasar.aptina.commons.util.AssertionUtils;
import org.seasar.aptina.commons.util.CollectionUtils;
import org.seasar.aptina.commons.util.DiagnosticUtils;
import org.seasar.aptina.commons.util.ElementUtils;
import org.seasar.aptina.commons.util.IOUtils;
import org.seasar.aptina.commons.util.TypeMirrorUtils;
import org.seasar.aptina.unit.SourceNotGeneratedException;
import org.seasar.aptina.unit.TestingJavaFileManager;

public abstract class AptinaTestCase
extends TestCase {
    Locale locale;
    Charset charset;
    Writer out;
    final List<String> options = CollectionUtils.newArrayList();
    final List<File> sourcePaths = CollectionUtils.newArrayList();
    final List<Processor> processors = CollectionUtils.newArrayList();
    final List<CompilationUnit> compilationUnits;
    JavaCompiler javaCompiler;
    DiagnosticCollector<JavaFileObject> diagnostics;
    StandardJavaFileManager standardJavaFileManager;
    JavaFileManager testingJavaFileManager;
    ProcessingEnvironment processingEnvironment;
    Boolean compiledResult;

    protected AptinaTestCase() {
        this.processors.add(new AptinaUnitProcessor());
        this.compilationUnits = CollectionUtils.newArrayList();
    }

    protected AptinaTestCase(String name) {
        super(name);
        this.processors.add(new AptinaUnitProcessor());
        this.compilationUnits = CollectionUtils.newArrayList();
    }

    protected void tearDown() throws Exception {
        if (this.testingJavaFileManager != null) {
            try {
                this.testingJavaFileManager.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.tearDown();
    }

    protected Locale getLocale() {
        return this.locale;
    }

    protected void setLocale(Locale locale) {
        this.locale = locale;
    }

    protected void setLocale(String locale) {
        AssertionUtils.assertNotEmpty("locale", locale);
        this.setLocale(new Locale(locale));
    }

    protected Charset getCharset() {
        return this.charset;
    }

    protected void setCharset(Charset charset) {
        this.charset = charset;
    }

    protected void setCharset(String charset) {
        AssertionUtils.assertNotEmpty("charset", charset);
        this.setCharset(Charset.forName(charset));
    }

    protected void setOut(Writer out) {
        this.out = out;
    }

    protected void addSourcePath(File ... sourcePaths) {
        AssertionUtils.assertNotEmpty("sourcePaths", sourcePaths);
        this.sourcePaths.addAll(Arrays.asList(sourcePaths));
    }

    protected void addSourcePath(String ... sourcePaths) {
        AssertionUtils.assertNotEmpty("sourcePaths", sourcePaths);
        for (String path : sourcePaths) {
            this.sourcePaths.add(new File(path));
        }
    }

    protected void addOption(String ... options) {
        AssertionUtils.assertNotEmpty("options", options);
        this.options.addAll(Arrays.asList(options));
    }

    protected void addProcessor(Processor ... processors) {
        AssertionUtils.assertNotEmpty("processors", processors);
        this.processors.addAll(Arrays.asList(processors));
    }

    protected void addCompilationUnit(Class<?> clazz) {
        AssertionUtils.assertNotNull("clazz", clazz);
        this.addCompilationUnit(clazz.getName());
    }

    protected void addCompilationUnit(String className) {
        AssertionUtils.assertNotEmpty("className", className);
        this.compilationUnits.add(new FileCompilationUnit(className));
    }

    protected void addCompilationUnit(Class<?> clazz, CharSequence source) {
        AssertionUtils.assertNotNull("clazz", clazz);
        AssertionUtils.assertNotEmpty("source", source);
        this.addCompilationUnit(clazz.getName(), source);
    }

    protected void addCompilationUnit(String className, CharSequence source) {
        AssertionUtils.assertNotEmpty("className", className);
        AssertionUtils.assertNotEmpty("source", source);
        this.compilationUnits.add(new InMemoryCompilationUnit(className, ((Object)source).toString()));
    }

    protected void compile() throws IOException {
        this.javaCompiler = ToolProvider.getSystemJavaCompiler();
        this.diagnostics = new DiagnosticCollector();
        LoggingDiagnosticListener listener = new LoggingDiagnosticListener(this.diagnostics);
        this.standardJavaFileManager = this.javaCompiler.getStandardFileManager(listener, this.locale, this.charset);
        this.standardJavaFileManager.setLocation(StandardLocation.SOURCE_PATH, this.sourcePaths);
        this.testingJavaFileManager = new TestingJavaFileManager(this.standardJavaFileManager, this.charset);
        JavaCompiler.CompilationTask task = this.javaCompiler.getTask(this.out, this.testingJavaFileManager, listener, this.options, null, this.getCompilationUnits());
        task.setProcessors(this.processors);
        this.compiledResult = task.call();
        this.compilationUnits.clear();
    }

    protected Boolean getCompiledResult() throws IllegalStateException {
        this.assertCompiled();
        return this.compiledResult;
    }

    protected List<Diagnostic<? extends JavaFileObject>> getDiagnostics() throws IllegalStateException {
        this.assertCompiled();
        return this.diagnostics.getDiagnostics();
    }

    protected List<Diagnostic<? extends JavaFileObject>> getDiagnostics(Class<?> clazz) {
        this.assertCompiled();
        return DiagnosticUtils.getDiagnostics(this.getDiagnostics(), clazz);
    }

    protected List<Diagnostic<? extends JavaFileObject>> getDiagnostics(String className) {
        this.assertCompiled();
        return DiagnosticUtils.getDiagnostics(this.getDiagnostics(), className);
    }

    protected List<Diagnostic<? extends JavaFileObject>> getDiagnostics(Diagnostic.Kind kind) {
        this.assertCompiled();
        return DiagnosticUtils.getDiagnostics(this.getDiagnostics(), kind);
    }

    protected List<Diagnostic<? extends JavaFileObject>> getDiagnostics(Class<?> clazz, Diagnostic.Kind kind) {
        this.assertCompiled();
        return DiagnosticUtils.getDiagnostics(this.getDiagnostics(), clazz, kind);
    }

    protected List<Diagnostic<? extends JavaFileObject>> getDiagnostics(String className, Diagnostic.Kind kind) {
        this.assertCompiled();
        return DiagnosticUtils.getDiagnostics(this.getDiagnostics(), className, kind);
    }

    protected ProcessingEnvironment getProcessingEnvironment() throws IllegalStateException {
        this.assertCompiled();
        return this.processingEnvironment;
    }

    protected Elements getElementUtils() throws IllegalStateException {
        this.assertCompiled();
        return this.processingEnvironment.getElementUtils();
    }

    protected Types getTypeUtils() throws IllegalStateException {
        this.assertCompiled();
        return this.processingEnvironment.getTypeUtils();
    }

    protected TypeElement getTypeElement(Class<?> clazz) throws IllegalStateException {
        this.assertCompiled();
        return ElementUtils.getTypeElement(this.getElementUtils(), clazz.getName());
    }

    protected TypeElement getTypeElement(String className) throws IllegalStateException {
        this.assertCompiled();
        return ElementUtils.getTypeElement(this.getElementUtils(), className);
    }

    protected VariableElement getFieldElement(TypeElement typeElement, Field field) throws IllegalStateException {
        this.assertCompiled();
        return ElementUtils.getFieldElement(typeElement, field);
    }

    protected VariableElement getFieldElement(TypeElement typeElement, String fieldName) throws IllegalStateException {
        this.assertCompiled();
        return ElementUtils.getFieldElement(typeElement, fieldName);
    }

    protected ExecutableElement getConstructorElement(TypeElement typeElement) throws IllegalStateException {
        this.assertCompiled();
        return ElementUtils.getConstructorElement(typeElement);
    }

    protected ExecutableElement getConstructorElement(TypeElement typeElement, Class<?> ... parameterTypes) throws IllegalStateException {
        this.assertCompiled();
        return ElementUtils.getConstructorElement(typeElement, parameterTypes);
    }

    protected ExecutableElement getConstructorElement(TypeElement typeElement, String ... parameterTypeNames) throws IllegalStateException {
        this.assertCompiled();
        return ElementUtils.getConstructorElement(typeElement, parameterTypeNames);
    }

    protected ExecutableElement getMethodElement(TypeElement typeElement, String methodName) throws IllegalStateException {
        this.assertCompiled();
        return ElementUtils.getMethodElement(typeElement, methodName);
    }

    protected ExecutableElement getMethodElement(TypeElement typeElement, String methodName, Class<?> ... parameterTypes) throws IllegalStateException {
        this.assertCompiled();
        return ElementUtils.getMethodElement(typeElement, methodName, parameterTypes);
    }

    protected ExecutableElement getMethodElement(TypeElement typeElement, String methodName, String ... parameterTypeNames) throws IllegalStateException {
        this.assertCompiled();
        return ElementUtils.getMethodElement(typeElement, methodName, parameterTypeNames);
    }

    protected TypeMirror getTypeMirror(Class<?> clazz) throws IllegalStateException {
        this.assertCompiled();
        return TypeMirrorUtils.getTypeMirror(this.getTypeUtils(), this.getElementUtils(), clazz);
    }

    protected TypeMirror getTypeMirror(String className) throws IllegalStateException {
        this.assertCompiled();
        return TypeMirrorUtils.getTypeMirror(this.getTypeUtils(), this.getElementUtils(), className);
    }

    protected String getGeneratedSource(Class<?> clazz) throws IllegalStateException, IOException, SourceNotGeneratedException {
        AptinaTestCase.assertNotNull((String)"clazz", clazz);
        this.assertCompiled();
        return this.getGeneratedSource(clazz.getName());
    }

    protected String getGeneratedSource(String className) throws IllegalStateException, IOException, SourceNotGeneratedException {
        AssertionUtils.assertNotEmpty("className", className);
        this.assertCompiled();
        JavaFileObject javaFileObject = this.testingJavaFileManager.getJavaFileForInput(StandardLocation.SOURCE_OUTPUT, className, JavaFileObject.Kind.SOURCE);
        if (javaFileObject == null) {
            throw new SourceNotGeneratedException(className);
        }
        CharSequence content = javaFileObject.getCharContent(true);
        if (content == null) {
            throw new SourceNotGeneratedException(className);
        }
        return ((Object)content).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assertEqualsByLine(String expected, String actual) {
        if (expected == null || actual == null) {
            AptinaTestCase.assertEquals((String)expected, (String)actual);
            return;
        }
        BufferedReader expectedReader = new BufferedReader(new StringReader(expected.toString()));
        BufferedReader actualReader = new BufferedReader(new StringReader(actual));
        try {
            this.assertEqualsByLine(expectedReader, actualReader);
        }
        catch (IOException ignore) {
        }
        finally {
            IOUtils.closeSilently(expectedReader);
            IOUtils.closeSilently(actualReader);
        }
    }

    protected void assertEqualsByLine(BufferedReader expectedReader, BufferedReader actualReader) throws IOException {
        String expectedLine;
        int lineNo = 0;
        while ((expectedLine = expectedReader.readLine()) != null) {
            String actualLine = actualReader.readLine();
            AptinaTestCase.assertEquals((String)("line:" + ++lineNo), (String)expectedLine, (String)actualLine);
        }
        AptinaTestCase.assertEquals((String)("line:" + ++lineNo), null, (String)actualReader.readLine());
    }

    protected void assertEqualsGeneratedSource(CharSequence expected, Class<?> clazz) throws IllegalStateException, IOException, SourceNotGeneratedException, ComparisonFailure {
        AssertionUtils.assertNotEmpty("expected", expected);
        AptinaTestCase.assertNotNull((String)"clazz", clazz);
        this.assertCompiled();
        this.assertEqualsGeneratedSource(expected, clazz.getName());
    }

    protected void assertEqualsGeneratedSource(CharSequence expected, String className) throws IllegalStateException, IOException, SourceNotGeneratedException, ComparisonFailure {
        AssertionUtils.assertNotEmpty("className", className);
        this.assertCompiled();
        String actual = this.getGeneratedSource(className);
        AptinaTestCase.assertNotNull((String)"actual", (Object)actual);
        this.assertEqualsByLine(expected == null ? null : ((Object)expected).toString(), actual);
    }

    protected void assertEqualsGeneratedSourceWithFile(File expectedSourceFile, Class<?> clazz) throws IllegalStateException, IOException, SourceNotGeneratedException, ComparisonFailure {
        AptinaTestCase.assertNotNull((String)"expectedSourceFile", (Object)expectedSourceFile);
        AptinaTestCase.assertNotNull((String)"clazz", clazz);
        this.assertCompiled();
        this.assertEqualsGeneratedSourceWithFile(expectedSourceFile, clazz.getName());
    }

    protected void assertEqualsGeneratedSourceWithFile(File expectedSourceFile, String className) throws IllegalStateException, IOException, SourceNotGeneratedException, ComparisonFailure {
        AptinaTestCase.assertNotNull((String)"expectedSourceFile", (Object)expectedSourceFile);
        AssertionUtils.assertNotEmpty("className", className);
        this.assertCompiled();
        this.assertEqualsGeneratedSource((CharSequence)IOUtils.readString(expectedSourceFile, this.charset), className);
    }

    protected void assertEqualsGeneratedSourceWithFile(String expectedSourceFilePath, Class<?> clazz) throws IllegalStateException, IOException, SourceNotGeneratedException, ComparisonFailure {
        AssertionUtils.assertNotEmpty("expectedSourceFilePath", expectedSourceFilePath);
        AptinaTestCase.assertNotNull((String)"clazz", clazz);
        this.assertCompiled();
        this.assertEqualsGeneratedSourceWithFile(expectedSourceFilePath, clazz.getName());
    }

    protected void assertEqualsGeneratedSourceWithFile(String expectedSourceFilePath, String className) throws IllegalStateException, IOException, SourceNotGeneratedException, ComparisonFailure {
        AssertionUtils.assertNotEmpty("expectedSourceFilePath", expectedSourceFilePath);
        AssertionUtils.assertNotEmpty("className", className);
        this.assertCompiled();
        this.assertEqualsGeneratedSourceWithFile(new File(expectedSourceFilePath), className);
    }

    protected void assertEqualsGeneratedSourceWithResource(URL expectedResourceUrl, Class<?> clazz) throws IllegalStateException, IOException, SourceNotGeneratedException, ComparisonFailure {
        AptinaTestCase.assertNotNull((String)"expectedResourceUrl", (Object)expectedResourceUrl);
        AptinaTestCase.assertNotNull((String)"clazz", clazz);
        this.assertCompiled();
        this.assertEqualsGeneratedSourceWithResource(expectedResourceUrl, clazz.getName());
    }

    protected void assertEqualsGeneratedSourceWithResource(URL expectedResourceUrl, String className) throws IllegalStateException, IOException, SourceNotGeneratedException, ComparisonFailure {
        AptinaTestCase.assertNotNull((String)"expectedResourceUrl", (Object)expectedResourceUrl);
        AssertionUtils.assertNotEmpty("className", className);
        this.assertCompiled();
        this.assertEqualsGeneratedSource((CharSequence)this.readFromResource(expectedResourceUrl), className);
    }

    protected void assertEqualsGeneratedSourceWithResource(String expectedResource, Class<?> clazz) throws IllegalStateException, IOException, SourceNotGeneratedException, ComparisonFailure {
        AssertionUtils.assertNotEmpty("expectedResource", expectedResource);
        AptinaTestCase.assertNotNull((String)"clazz", clazz);
        this.assertCompiled();
        this.assertEqualsGeneratedSourceWithResource(clazz.getName(), expectedResource);
    }

    protected void assertEqualsGeneratedSourceWithResource(String expectedResource, String className) throws IllegalStateException, IOException, SourceNotGeneratedException, ComparisonFailure {
        AssertionUtils.assertNotEmpty("expectedResource", expectedResource);
        AssertionUtils.assertNotEmpty("className", className);
        this.assertCompiled();
        URL url = Thread.currentThread().getContextClassLoader().getResource(expectedResource);
        if (url == null) {
            throw new FileNotFoundException(expectedResource);
        }
        this.assertEqualsGeneratedSourceWithResource(url, className);
    }

    protected void reset() {
        this.locale = null;
        this.charset = null;
        this.out = null;
        this.options.clear();
        this.sourcePaths.clear();
        this.processors.clear();
        this.processors.add(new AptinaUnitProcessor());
        this.compilationUnits.clear();
        this.javaCompiler = null;
        this.diagnostics = null;
        this.standardJavaFileManager = null;
        if (this.testingJavaFileManager != null) {
            try {
                this.testingJavaFileManager.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.testingJavaFileManager = null;
        this.processingEnvironment = null;
        this.compiledResult = null;
    }

    List<JavaFileObject> getCompilationUnits() throws IOException {
        ArrayList<JavaFileObject> result = new ArrayList<JavaFileObject>(this.compilationUnits.size());
        for (CompilationUnit compilationUnit : this.compilationUnits) {
            result.add(compilationUnit.getJavaFileObject());
        }
        return result;
    }

    void assertCompiled() throws IllegalStateException {
        if (this.compiledResult == null) {
            throw new IllegalStateException("not compiled");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String readFromResource(URL url) throws IOException {
        InputStream is = url.openStream();
        try {
            String string = IOUtils.readString(is, this.charset);
            return string;
        }
        finally {
            IOUtils.closeSilently(is);
        }
    }

    class InMemoryCompilationUnit
    implements CompilationUnit {
        String className;
        String source;

        public InMemoryCompilationUnit(String className, String source) {
            this.className = className;
            this.source = source;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public JavaFileObject getJavaFileObject() throws IOException {
            JavaFileObject javaFileObject = AptinaTestCase.this.testingJavaFileManager.getJavaFileForOutput(StandardLocation.SOURCE_OUTPUT, this.className, JavaFileObject.Kind.SOURCE, null);
            Writer writer = javaFileObject.openWriter();
            try {
                writer.write(this.source);
            }
            finally {
                IOUtils.closeSilently(writer);
            }
            return javaFileObject;
        }
    }

    class FileCompilationUnit
    implements CompilationUnit {
        String className;

        public FileCompilationUnit(String className) {
            this.className = className;
        }

        @Override
        public JavaFileObject getJavaFileObject() throws IOException {
            return AptinaTestCase.this.standardJavaFileManager.getJavaFileForInput(StandardLocation.SOURCE_PATH, this.className, JavaFileObject.Kind.SOURCE);
        }
    }

    static interface CompilationUnit {
        public JavaFileObject getJavaFileObject() throws IOException;
    }

    @SupportedSourceVersion(value=SourceVersion.RELEASE_6)
    @SupportedAnnotationTypes(value={"*"})
    class AptinaUnitProcessor
    extends AbstractProcessor {
        AptinaUnitProcessor() {
        }

        @Override
        public synchronized void init(ProcessingEnvironment processingEnvironment) {
            super.init(processingEnvironment);
            AptinaTestCase.this.processingEnvironment = processingEnvironment;
        }

        @Override
        public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
            return false;
        }
    }

    static class LoggingDiagnosticListener
    implements DiagnosticListener<JavaFileObject> {
        DiagnosticListener<JavaFileObject> listener;

        LoggingDiagnosticListener(DiagnosticListener<JavaFileObject> listener) {
            this.listener = listener;
        }

        @Override
        public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
            System.out.println(diagnostic);
            this.listener.report(diagnostic);
        }
    }
}

