/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.aptina.commons.util;

import org.seasar.aptina.commons.util.AssertionUtils;
import org.seasar.aptina.commons.util.StringUtils;

public class ClassUtils {
    private ClassUtils() {
    }

    public static String getQualifiedName(String packageName, String simpleName) {
        if (StringUtils.isEmpty(packageName)) {
            return simpleName;
        }
        return packageName + "." + simpleName;
    }

    public static String getPackageName(String qualifiedName) {
        int pos = qualifiedName.lastIndexOf(46);
        if (pos == -1) {
            return null;
        }
        return qualifiedName.substring(0, pos);
    }

    public static String getQualifiedName(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isArray()) {
            return ClassUtils.getQualifiedName(clazz.getComponentType()) + "[]";
        }
        return clazz.getName();
    }

    public static String[] getQualifiedNameArray(Class<?> ... classes) {
        AssertionUtils.assertNotNull("classes", classes);
        String[] qualifiedNames = new String[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            qualifiedNames[i] = ClassUtils.getQualifiedName(classes[i]);
        }
        return qualifiedNames;
    }

    public static String getSimpleName(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isArray()) {
            return ClassUtils.getSimpleName(clazz.getComponentType()) + "[]";
        }
        return clazz.getSimpleName();
    }

    public static String[] getSimpleNameArray(Class<?> ... classes) {
        AssertionUtils.assertNotNull("clsses", classes);
        String[] simpleNames = new String[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            simpleNames[i] = ClassUtils.getSimpleName(classes[i]);
        }
        return simpleNames;
    }
}

