package com.kurukurupapa.tryandroidui.notification;

import com.kurukurupapa.tryandroidui.R;

import android.app.Activity;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;

public class NotificationActivity extends Activity {
	public Button showButton;
	public Button hideButton;
	public Button upButton;
	public Button downButton;
	public EditText iconLevelEditText;

	private Notification notification;
	private int notificationId;

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);

		setContentView(R.layout.notification_activity);
		showButton = (Button) findViewById(R.id.show_button);
		hideButton = (Button) findViewById(R.id.hide_button);
		upButton = (Button) findViewById(R.id.up_button);
		downButton = (Button) findViewById(R.id.down_button);
		iconLevelEditText = (EditText) findViewById(R.id.icon_level_edit_text);

		notification = null;
		notificationId = 1;
		updateData();
	}

	public void showButton_OnClick(View v) {
		if (notification != null) {
			return;
		}

		// 通知ウインドウをクリックした際に起動するインテント
		Intent intent = new Intent(this, this.getClass());
		PendingIntent pendingIntent = PendingIntent.getActivity(this, 0,
				intent, 0);

		// ステータスバー通知の設定
		notification = new Notification(R.drawable.level_list,
				"Notificationテストです", System.currentTimeMillis());
		notification.iconLevel = 0;

		// 通知ウインドウのメッセージ
		notification.setLatestEventInfo(this, "NotificationActivity",
				"Notificationテスト", pendingIntent);

		// ノーティフィケーション通知
		((NotificationManager) getSystemService(Context.NOTIFICATION_SERVICE))
				.notify(notificationId, notification);

		updateData();
	}

	public void hideButton_OnClick(View v) {
		if (notification == null) {
			return;
		}

		NotificationManager manager = (NotificationManager) getSystemService(Context.NOTIFICATION_SERVICE);
		manager.cancel(notificationId);
		notification = null;
		updateData();
	}

	public void upButton_OnClick(View v) {
		if (notification == null) {
			return;
		}

		notification.iconLevel++;
		updateData();
	}

	public void downButton_OnClick(View v) {
		if (notification == null) {
			return;
		}

		notification.iconLevel--;
		updateData();
	}

	private void updateData() {
		showButton.setEnabled(notification == null);
		hideButton.setEnabled(notification != null);
		upButton.setEnabled(notification != null);
		downButton.setEnabled(notification != null);
		iconLevelEditText.setEnabled(notification != null);

		if (notification != null) {
			iconLevelEditText.setText(String.valueOf(notification.iconLevel));
			notification.setLatestEventInfo(this, "NotificationActivity "
					+ notification.iconLevel, "Notificationテスト "
					+ notification.iconLevel, notification.contentIntent);
			((NotificationManager) getSystemService(Context.NOTIFICATION_SERVICE))
					.notify(notificationId, notification);
		}
	}
}