package com.kurukurupapa.tryandroidui.draglist2;

import com.kurukurupapa.tryandroidui.R;

import android.app.Activity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;

/**
 * ドラッグアンドドロップで並び替え可能なリストビュー用のデータアダプタークラス（リスト項目は2つのテキスト）
 */
public class DragListAdapter2 extends BaseAdapter {
	private String[][] items = { { "Android 1.0（APIレベル1）", "" },
			{ "Android 1.1（APIレベル2）", "" },
			{ "Android 1.5（APIレベル3）", "Cupcake（カップケーキ）" },
			{ "Android 1.6（APIレベル4）", "Donut（ドーナツ）" },
			{ "Android 2.0（APIレベル5）", "Eclair（エクレア）" },
			{ "Android 2.0.1（APIレベル6）", "Eclair（エクレア）" },
			{ "Android 2.1（APIレベル7）", "Eclair（エクレア）" },
			{ "Android 2.2（APIレベル8）", "Froyo(Frozen Yogurt)（フローズンヨーグルト）" },
			{ "Android 2.3（APIレベル9）", "Gingerbread（ジンジャーブレッド）" },
			{ "Android 2.3.3（APIレベル10）", "Gingerbread（ジンジャーブレッド）" },
			{ "Android 3.0（APIレベル11）", "Honeycomb（蜂の巣）" },
			{ "Android 3.1（APIレベル12）", "Honeycomb（蜂の巣）" },
			{ "Android 3.2（APIレベル13）", "Honeycomb（蜂の巣）" },
			{ "Android 4.0（APIレベル14）", "Ice Cream Sandwich（アイスクリームサンドイッチ）" }, };
	private LayoutInflater inflater;
	private int currentPosition = -1;

	public DragListAdapter2(Activity activity) {
		inflater = activity.getLayoutInflater();
	}

	@Override
	public int getCount() {
		return items.length;
	}

	@Override
	public Object getItem(int position) {
		return items[position];
	}

	@Override
	public long getItemId(int position) {
		return position;
	}

	/**
	 * リスト項目のViewを取得する
	 */
	@Override
	public View getView(int position, View convertView, ViewGroup parent) {
		// View作成
		ViewHolder viewHolder;
		if (convertView == null) {
			viewHolder = new ViewHolder();
			convertView = inflater.inflate(R.layout.drag_list_item, null);
			convertView.setTag(viewHolder);
			viewHolder.text1 = (TextView) convertView.findViewById(R.id.text1);
			viewHolder.text2 = (TextView) convertView.findViewById(R.id.text2);
		} else {
			viewHolder = (ViewHolder) convertView.getTag();
		}

		// データ設定
		String[] item = (String[]) getItem(position);
		viewHolder.text1.setText(item[0]);
		viewHolder.text2.setText(item[1]);

		// ドラッグ対象項目は、ListView側で別途描画するため、非表示にする。
		if (position == currentPosition) {
			convertView.setVisibility(View.INVISIBLE);
		} else {
			convertView.setVisibility(View.VISIBLE);
		}
		return convertView;
	}

	/**
	 * ドラッグ開始
	 *
	 * @param position
	 */
	public void startDrag(int position) {
		this.currentPosition = position;
	}

	/**
	 * ドラッグに従ってデータを並び替える
	 *
	 * @param newPosition
	 */
	public void doDrag(int newPosition) {
		String[] item = items[currentPosition];
		if (currentPosition < newPosition) {
			// リスト項目を下に移動している場合
			for (int i = currentPosition; i < newPosition; i++) {
				items[i] = items[i + 1];
			}
		} else if (currentPosition > newPosition) {
			// リスト項目を上に移動している場合
			for (int i = currentPosition; i > newPosition; i--) {
				items[i] = items[i - 1];
			}
		}
		items[newPosition] = item;

		currentPosition = newPosition;
	}

	/**
	 * ドラッグ終了
	 */
	public void stopDrag() {
		this.currentPosition = -1;
	}

}
