package com.kurukurupapa.tryandroidui.font;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.view.View;

public class FontView extends View {
	private static int TEXT_SIZE = 30;
	private static int TEXT_PADDING = (int) (TEXT_SIZE * 0.1);
	private int x;
	private int y;

	public FontView(Context context) {
		super(context);
	}

	/*
	 * (非 Javadoc)
	 *
	 * @see android.view.View#onDraw(android.graphics.Canvas)
	 */
	@Override
	protected void onDraw(Canvas canvas) {
		canvas.drawColor(Color.WHITE);
		x = 0;
		y = TEXT_SIZE;

		// アンチエイリアシング
		boolean[] flags = new boolean[] { //
		true, // こっちを使うべき
		// false, // テキスト描画で「アンチエイリアシングなし」は厳しい
		};

		// フォントファミリー
		Typeface[] typefaces = new Typeface[] {
		// Typeface.DEFAULT, // SANS_SERIFと同じ
				// Typeface.DEFAULT_BOLD,
				Typeface.MONOSPACE, // 当幅
				Typeface.SANS_SERIF, // サンセリフ
				Typeface.SERIF, // セリフ
		};

		// スタイル
		int[] styles = new int[] { //
		Typeface.NORMAL, //
				Typeface.BOLD, //
				// Typeface.BOLD_ITALIC,
				Typeface.ITALIC, //
		};

		for (boolean flag : flags) {
			for (Typeface typeface : typefaces) {
				for (int style : styles) {
					drawText(canvas, flag, typeface, style);
				}
				y += TEXT_PADDING * 2;
			}
		}
	}

	private void drawText(Canvas canvas, boolean flag, Typeface family,
			int style) {
		Paint paint = new Paint();
		paint.setAntiAlias(flag);
		paint.setTypeface(Typeface.create(family, style));
		paint.setTextSize(TEXT_SIZE);
		canvas.drawText("abcABCあいう壱弐参", x, y, paint);
		y += TEXT_SIZE + TEXT_PADDING;
	}

}
