# Windows PowerShell
# Ot@C𑀍삷TvłB

Set-StrictMode -Version Latest
$PSDefaultParameterValues = @{"ErrorAction"="Stop"}
$baseDir = Convert-Path $(Split-Path -Path $MyInvocation.InvocationName -Parent)

# Ost͈͂Ɋ܂܂邩肷B
# $line - Os
# $startTimestamp - Jni"yyyy/MM/dd HH:mm:ss"j
# $endTimestamp - Ii"yyyy/MM/dd HH:mm:ss"j
# return - $true, $false, $null
function U-Compare-Timestamp($line, $startTimestamp, $endTimestamp) {
    # Ost𔲂o
    $timestamp = $null
    if ($line -match "[^\d](\d{4}/\d{2}/\d{2}):(\d{2}:\d{2}:\d{2})[^\d]") {
        $timestamp = $($matches[1] + " " + $matches[2])
    }
    elseif ($line -match "[^\d](\d{4}/\d{2}/\d{2} \d{2}:\d{2}:\d{2})[^\d]") {
        $timestamp = $matches[1]
    }
    elseif ($line -match "[^\d](\d{4}-\d{2}-\d{2} \d{2}:\d{2}:\d{2})[^\d]") {
        $timestamp = $matches[1] -replace "-", "/"
    }
    
    # t͈͂Ɋ܂܂Ă邩肷
    if ($timestamp -eq $null) {
        return $null
    } else {
        if ($timestamp -ge $startTimestamp) {
            if ($timestamp -le $endTimestamp) {
                return $true
            }
        }
    }
    return $false
}

# ApacheANZXO
$infile = Join-Path $basedir "testdata\ApacheAccess.log"
$startTimestamp = "2000/10/10 13:55:37"
$endTimestamp   = "2000/10/10 14:55:36"
$outFlag = $false
Get-Content $infile | %{
    # st𔲂oAs̏o͂𔻒肷B
    # t𔲂oȂAO̍sɏ]āAo͂B
    $compare = U-Compare-Timestamp $_ $startTimestamp $endTimestamp
    if ($compare -ne $null) {
        $outFlag = $compare
    }
    # so͂
    if ($outFlag) {
        $_
    }
}

echo $("*" * 70)

# ApacheG[O
$infile = Join-Path $basedir "testdata\ApacheError.log"
$startTimestamp = "2000/10/11 14:32:53"
$endTimestamp   = "2000/10/11 15:32:52"
$outFlag = $false
Get-Content $infile | %{
    # st𔲂oAs̏o͂𔻒肷B
    # t𔲂oȂAO̍sɏ]āAo͂B
    $compare = U-Compare-Timestamp $_ $startTimestamp $endTimestamp
    if ($compare -ne $null) {
        $outFlag = $compare
    }
    # so͂
    if ($outFlag) {
        $_
    }
}
