# Windows PowerShell
# ȂlIȃVXeJ̓
#
# 2013/04/04 VK쐬

Set-StrictMode -Version Latest
$PSDefaultParameterValues = @{"ErrorAction"="Stop"}

######################################################################
### 萔`
######################################################################
$baseDir = Convert-Path $(Split-Path -Path $MyInvocation.InvocationName -Parent)
$tmpDir = Join-Path $baseDir "tmp"
$arcDir = Join-Path $tmpDir "archives"
$unarcDir = Join-Path $tmpDir "unarchive"
$toolDir = $baseDir
$unzipPath = Join-Path $toolDir "gnuwin32\bin\unzip.exe"
$is64bit = -not $($env:PROCESSOR_ARCHITECTURE -eq "x86")

######################################################################
### ֐`
######################################################################

# c[B
# $srcUrl - A[JCut@CURL
# $destDir - A[JCuWJfBNg
# return - Ȃ
function U-Setup-Archive($srcUrl, $destDir, $fname = $null, $destCheck = $null) {
    # _E[ht@Cۑ̃pXݒ
    if ($fname -eq $null) {
        $fname = U-Get-Name -url $srcUrl
    }
    $tmpPath = Join-Path $arcDir $fname
    
    # WJς݃`FbÑpXݒ
    if ($destCheck -eq $null) {
        $destCheck = $destDir
    }
    
    # ɁAWJς݂̏ꍇAȂB
    if (-not $(Test-Path $destCheck)) {
        # A[JCut@C_E[h
        if (-not $(Test-Path $tmpPath)) {
            U-Download-File -srcUrl $srcUrl -destPath $tmpPath
        }
        
        # A[JCut@CWJ
        U-Unarchive-File -srcPath $tmpPath -destDir $destDir
        
        # binfBNg΃pXʂ
        $binDir = Join-Path $destDir "bin"
        if (Test-Path $binDir) {
            U-AddTo-PathEnv $binDir
        }
    } else {
        echo "XLbv $srcUrl"
    }
    return
}

# c[B
# $srcUrl - t@CURL
# $destDir - zufBNg
# return - Ȃ
function U-Setup-File($srcUrl, $destDir) {
    $fname = U-Get-Name -url $srcUrl
    $destPath = Join-Path $destDir $fname
    if (-not $(Test-Path $destPath)) {
        New-Item -ItemType directory -Force $destDir | Out-Null
        U-Download-File -srcUrl $srcUrl -destPath $destPath
    }
    return
}

# A[JCut@C_E[hB
# $srcUrl - _E[hURL
# $destPath - ۑpX
# return - Ȃ
function U-Download-File($srcUrl, $destPath) {
    $webClient = New-Object System.Net.WebClient
    Write-Output "_E[hJn $srcUrl"
    try {
        $webClient.DownloadFile($srcUrl, $destPath)
    }
    catch {
        Write-Error $_
        exit 1
    }
    #Write-Output "I"
    return
}

# ƃfBNg̃A[JCut@CWJB
# $srcPath - A[JCut@C
# $destDir - WJfBNg
# return - Ȃ
function U-Unarchive-File($srcPath, $destDir) {
    Write-Output "A[JCut@CWJJn $srcPath"
    if (Test-Path $unzipPath) {
        # WJfBNg̒
        $dirs = @(
            .\gnuwin32\bin\unzip.exe -l -qq $srcPath | %{
                $columns = $_ -split " +"
                $dirs = $columns[6] -split "/"
                $dirs[0]
            } | sort | Get-Unique
        )
        if ($dirs.Length -eq 1) {
            $destDir = Split-Path -Parent $destDir
        }
        
        # GnuWin32unzip.exegēWJ
        # E㏑
        # EI܂őҋ@
        Start-Process $unzipPath -ArgumentList -o, $srcPath, -d, $destDir -Wait -WindowStyle Minimized
    } else {
        New-Item -ItemType directory -Force $destDir | Out-Null
        
        # WindowsW@\œWJ
        $sh = New-Object -ComObject Shell.Application
        $srcPathObj = $sh.NameSpace($srcPath)
        $destDirObj = $sh.NameSpace($destDir)
        $destDirObj.CopyHere($srcPathObj.Items())
    }
    #Write-Output "I"
    return
}

# URLt@C̖O擾B
# $url - URL
# return - t@C
function U-Get-Name($url) {
    return [System.IO.Path]::GetFileName($url)
}

# fBNg폜B
# $dir - 폜ΏۃfBNg
# return - Ȃ
function U-Remove-Dir($dir) {
    if (Test-Path $dir) {
        Remove-Item -Force -Recurse $dir
    }
    return
}

# ϐPATHɃc[̎sfBNgǉB
# $dir - ǉfBNg
# return - Ȃ
function U-AddTo-PathEnv($dir) {
    if ($env:path -notlike $("*" + $dir + "*")) {
        $env:path = $env:path + ";" + $dir
        [System.Environment]::SetEnvironmentVariable("Path", $env:path, [System.EnvironmentVariableTarget]::User)
    }
    return
}

######################################################################
### s
######################################################################

###
### O
###

# JgfBNgݒ
Push-Location $baseDir

# ƃfBNgȂǍ쐬
New-Item -ItemType directory -Force $arcDir | Out-Null
New-Item -ItemType directory -Force $toolDir | Out-Null

###
### R}hE
###

# GnuWin32
# Eunzipn߂Ɏ{Aȍ~̏ł́Aunzip.exegpB
$destDir = Join-Path $toolDir "gnuwin32"
$gnuwinList = @( `
    @("http://sourceforge.net/projects/gnuwin32/files/unzip/5.51-1/unzip-5.51-1-bin.zip", $(Join-Path $destDir "bin\unzip.exe")),
    @("http://sourceforge.net/projects/gnuwin32/files/diffutils/2.8.7-1/diffutils-2.8.7-1-dep.zip", $(Join-Path $destDir "bin\diff.exe")),
    @("http://sourceforge.net/projects/gnuwin32/files/diffutils/2.8.7-1/diffutils-2.8.7-1-bin.zip", $(Join-Path $destDir "bin\diff.exe")),
    @("http://sourceforge.net/projects/gnuwin32/files/findutils/4.2.20-2/findutils-4.2.20-2-dep.zip", $(Join-Path $destDir "bin\find.exe")),
    @("http://sourceforge.net/projects/gnuwin32/files/findutils/4.2.20-2/findutils-4.2.20-2-bin.zip", $(Join-Path $destDir "bin\find.exe")),
    @("http://sourceforge.net/projects/gnuwin32/files/gawk/3.1.6-1/gawk-3.1.6-1-bin.zip", $(Join-Path $destDir "bin\gawk.exe")),
    @("http://sourceforge.net/projects/gnuwin32/files/grep/2.5.4/grep-2.5.4-dep.zip", $(Join-Path $destDir "bin\grep.exe")),
    @("http://sourceforge.net/projects/gnuwin32/files/grep/2.5.4/grep-2.5.4-bin.zip", $(Join-Path $destDir "bin\grep.exe")),
    @("http://sourceforge.net/projects/gnuwin32/files/gzip/1.3.12-1/gzip-1.3.12-1-bin.zip", $(Join-Path $destDir "bin\gzip.exe")),
    @("http://sourceforge.net/projects/gnuwin32/files/sed/4.2.1/sed-4.2.1-dep.zip", $(Join-Path $destDir "bin\sed.exe")),
    @("http://sourceforge.net/projects/gnuwin32/files/sed/4.2.1/sed-4.2.1-bin.zip", $(Join-Path $destDir "bin\sed.exe")),
    @("http://sourceforge.net/projects/gnuwin32/files/tar/1.13-1/tar-1.13-1-dep.zip", $(Join-Path $destDir "bin\tar.exe")),
    @("http://sourceforge.net/projects/gnuwin32/files/tar/1.13-1/tar-1.13-1-bin.zip", $(Join-Path $destDir "bin\tar.exe")),
    @("http://sourceforge.net/projects/gnuwin32/files/wget/1.11.4-1/wget-1.11.4-1-dep.zip", $(Join-Path $destDir "bin\wget.exe")),
    @("http://sourceforge.net/projects/gnuwin32/files/wget/1.11.4-1/wget-1.11.4-1-bin.zip", $(Join-Path $destDir "bin\wget.exe")),
    @("http://sourceforge.net/projects/gnuwin32/files/zip/3.0/zip-3.0-dep.zip", $(Join-Path $destDir "bin\zip.exe")),
    @("http://sourceforge.net/projects/gnuwin32/files/zip/3.0/zip-3.0-bin.zip", $(Join-Path $destDir "bin\zip.exe")))
#"http://sourceforge.net/projects/gnuwin32/files/coreutils/5.3.0/coreutils-5.3.0-bin.zip"
#"http://sourceforge.net/projects/gnuwin32/files/coreutils/5.3.0/coreutils-5.3.0-dep.zip"
foreach($gnuwin in $gnuwinList) {
    U-Setup-Archive -srcUrl $gnuwin[0] -destDir $destDir -destCheck $gnuwin[1]
}

# Ruby
if ($is64bit) {
    U-Setup-Archive `
        -srcUrl "ftp://ftp.ruby-lang.org/pub/ruby/binaries/mswin32/ruby-1.9.2-p0-x64-mswin64_80.zip" `
        -destDir $(Join-Path $toolDir "ruby-1.9.2-p0-x64-mswin64_80")
} else {
    U-Setup-Archive `
        -srcUrl "ftp://ftp.ruby-lang.org/pub/ruby/binaries/mswin32/ruby-1.9.2-p136-i386-mswin32.zip" `
        -destDir $(Join-Path $toolDir "ruby-1.9.2-p136-i386-mswin32")
}

# Subversion
U-Setup-Archive `
    -srcUrl "http://subversion.tigris.org/files/documents/15/47914/svn-win32-1.6.6.zip" `
    -destDir $(Join-Path $toolDir "svn-win32-1.6.6")

###
### Java֘A
###

# Ant
U-Setup-Archive `
    -srcUrl "http://ftp.kddilabs.jp/infosystems/apache/ant/binaries/apache-ant-1.9.0-bin.zip" `
    -destDir $(Join-Path $toolDir "apache-ant-1.9.0")

# StepCounter
# https://github.com/takezoe/stepcounter
U-Setup-Archive `
    -srcUrl "https://github.com/takezoe/stepcounter/archive/3.0.1.zip" `
    -destDir $(Join-Path $toolDir "stepcounter-3.0.1")

###
### FX
###

## Jenkins
#U-Setup-File `
#    -srcUrl "http://mirrors.jenkins-ci.org/war/latest/jenkins.war" `
#    -destDir $(Join-Path $toolDir "jenkins")

## FastStone Capture 5.3it[EFAł̍ŐVj
## http://www.faststone.org/FSCaptureDetail.htm
#$destDir = Join-Path $toolDir "fscapture"
#U-Setup-Archive `
#    -srcUrl "http://www.aplusfreeware.com/categories/mmedia/files/fscapture.zip" `
#    -destDir $destDir
#U-AddTo-PathEnv $destDir

# RubyMiniCmd
# http://sourceforge.jp/projects/rubyminicmd/releases/?package_id=6370
U-Setup-Archive `
    -srcUrl "http://sourceforge.jp/frs/redir.php?m=jaist&f=/rubyminicmd/27373/rubyminicmd-20070930.zip" `
    -destDir $(Join-Path $toolDir "rubyminicmd-20070930")

## C#.NET MiniCmd
## http://sourceforge.jp/projects/rubyminicmd/releases/?package_id=9727
#$destDir = Join-Path $toolDir "vcsminicmd-0.4.2"
#U-Setup-Archive `
#    -srcUrl "http://sourceforge.jp/frs/redir.php?m=jaist&f=/rubyminicmd/50052/vcsminicmd-0.4.2.zip" `
#    -destDir $destDir
#U-AddTo-PathEnv $destDir

###
### ЕtȂ
###
$env:TOOLBOX_HOME = $baseDir
[System.Environment]::SetEnvironmentVariable("TOOLBOX_HOME", $env:TOOLBOX_HOME, [System.EnvironmentVariableTarget]::User)

# JgfBNg߂
Pop-Location

echo "I"
exit 0
