# Windows PowerShell
# \[Xt@C̃XebvvTvłB

Set-StrictMode -Version Latest
$PSDefaultParameterValues = @{"ErrorAction"="Stop"}
$DebugPreference = "Continue"
$baseDir = Convert-Path $(Split-Path -Path $MyInvocation.InvocationName -Parent)
$stepcounterpath = Join-Path $env:TOOLBOX_HOME "stepcounter-3.0.1\eclipse-plugin\jp.sf.amateras.stepcounter\lib\stepcounter-3.0.1-jar-with-dependencies.jar"

###
### ֐`
###

# XebvvB
# $beforeDir - ύXO\[X̃fBNg
# $afterDir - ύX\[X̃fBNg
# return - Ȃ
function U-Count-Step($beforeDir, $afterDir, ${outName}) {
    # S̃JEg
    java -cp $stepcounterpath jp.sf.amateras.stepcounter.Main $afterDir -showDirectory=true "-output=${outName}_Step.txt"
    Get-Content "${outName}_Step.txt" | Write-Debug
    java -cp $stepcounterpath jp.sf.amateras.stepcounter.Main $afterDir -showDirectory=true -format=csv "-output=${outName}_Step.csv"
    java -cp $stepcounterpath jp.sf.amateras.stepcounter.Main $afterDir -showDirectory=true -format=excel "-output=${outName}_Step.xls"
    # JEg
    java -cp $stepcounterpath jp.sf.amateras.stepcounter.diffcount.Main $afterDir $beforeDir -format=csv "-output=${outName}_DiffStep.csv"
    java -cp $stepcounterpath jp.sf.amateras.stepcounter.diffcount.Main $afterDir $beforeDir -format=excel "-output=${outName}_DiffStep.xls"
}

###
### s
###

Write-Debug "XNvg Start"

$beforeDir = Join-Path $baseDir "testdata\stepcounter\before"
$afterDir = Join-Path $baseDir "testdata\stepcounter\after"
U-Count-Step $beforeDir $afterDir "StepCounterPs1"

Write-Debug "XNvg End"
