# Windows PowerShell
# \[Xt@C̃XebvvTvłB
param($beforeDir, $afterDir, $outName)

Set-StrictMode -Version Latest
$PSDefaultParameterValues = @{"ErrorAction"="Stop"}
$ErrorActionPreference = "Stop"
$WarningPreference = "Continue"
$DebugPreference = "Continue"

######################################################################
### ֐`
######################################################################

# gp@o͂B
# return - Ȃ
function U-Write-Usage() {
    Write-Output "gF$psName ύXO\[XfBNg ύX\[XfBNg o̓t@Cړ"
}

# XebvvB
# $beforeDir - ύXO\[X̃fBNg
# $afterDir - ύX\[X̃fBNg
# return - Ȃ
function U-Count-Step() {
    # S̃JEg
    java -cp $stepcounterpath jp.sf.amateras.stepcounter.Main $afterDir -showDirectory=true "-output=${outName}_Step.txt"
    Get-Content "${outName}_Step.txt" | Write-Debug
    java -cp $stepcounterpath jp.sf.amateras.stepcounter.Main $afterDir -showDirectory=true -format=csv "-output=${outName}_Step.csv"
    java -cp $stepcounterpath jp.sf.amateras.stepcounter.Main $afterDir -showDirectory=true -format=excel "-output=${outName}_Step.xls"
    # JEg
    java -cp $stepcounterpath jp.sf.amateras.stepcounter.diffcount.Main $afterDir $beforeDir -format=csv "-output=${outName}_DiffStep.csv"
    java -cp $stepcounterpath jp.sf.amateras.stepcounter.diffcount.Main $afterDir $beforeDir -format=excel "-output=${outName}_DiffStep.xls"
}

######################################################################
### s
######################################################################

###
### O
###

Write-Debug "XNvg Start"

$baseDir = Convert-Path $(Split-Path $MyInvocation.InvocationName -Parent)
$psName = Split-Path $MyInvocation.InvocationName -Leaf
$psBaseName = $psName -replace "\.ps1$", ""
$timestamp = Get-Date -Format "yyyyMMdd-HHmmss"
$stepcounterpath = Join-Path $env:TOOLBOX_HOME "stepcounter-3.0.1\eclipse-plugin\jp.sf.amateras.stepcounter\lib\stepcounter-3.0.1-jar-with-dependencies.jar"

###
### 又
###

if ($($beforeDir -eq $null) -or $($afterDir -eq $null)) {
    U-Write-Usage
} else {
	U-Count-Step
}

###
### ㏈
###

Write-Debug "XNvg End"
