# Windows PowerShell
# \[Xt@C̃XebvvTvłB
param($beforeDir, $afterDir, $outDir)

Set-StrictMode -Version Latest
$PSDefaultParameterValues = @{"ErrorAction"="Stop"}
$ErrorActionPreference = "Stop"
$WarningPreference = "Continue"
$VerbosePreference = "Continue"
$DebugPreference = "Continue"

######################################################################
### ֐`
######################################################################

# gp@o͂B
# return - Ȃ
function U-Write-Usage() {
    Write-Output "gF$psName ύXO\[XfBNg ύX\[XfBNg o̓fBNg"
}

# XebvvB
# $beforeDir - ύXO\[X̃fBNg
# $afterDir - ύX\[X̃fBNg
# return - Ȃ
function U-Count-Step() {
    New-Item -Force -ItemType Directory $outDir | Out-Null
    
    # S̃JEg
    #Write-Verbose "ύX\[XJEgieLXg`j"
    #java -cp $jarPath jp.sf.amateras.stepcounter.Main $afterDir -showDirectory=true "-output=${outDir}\AfterStep.txt"
    #Get-Content "${outDir}\AfterStep.txt" | Write-Debug
    Write-Verbose "ύX\[XJEgiCSV`j"
    java -cp $jarPath jp.sf.amateras.stepcounter.Main $afterDir -showDirectory=true -format=csv "-output=${outDir}\AfterStep.csv"
    Write-Verbose "ύX\[XJEgiExcel`j"
    java -cp $jarPath jp.sf.amateras.stepcounter.Main $afterDir -showDirectory=true -format=excel "-output=${outDir}\AfterStep.xls"

    # JEg
    Write-Verbose "\[XJEgiCSV`j"
    java -cp $jarPath jp.sf.amateras.stepcounter.diffcount.Main $afterDir $beforeDir -format=csv "-output=${outDir}\DiffStep.csv"
    Write-Verbose "\[XJEgiExcel`j"
    java -cp $jarPath jp.sf.amateras.stepcounter.diffcount.Main $afterDir $beforeDir -format=excel "-output=${outDir}\DiffStep.xls"
}

######################################################################
### s
######################################################################

###
### O
###

$baseDir = Convert-Path $(Split-Path $MyInvocation.InvocationName -Parent)
$psName = Split-Path $MyInvocation.InvocationName -Leaf
$psBaseName = $psName -replace "\.ps1$", ""
$jarPath = "$baseDir\..\stepcounter-3.0.1\eclipse-plugin\jp.sf.amateras.stepcounter\lib\stepcounter-3.0.1-jar-with-dependencies.jar"

Write-Verbose "$psName Start"

###
### 又
###

if ($($beforeDir -eq $null) -or $($afterDir -eq $null)) {
    U-Write-Usage
} else {
	U-Count-Step
}

###
### ㏈
###
Write-Verbose "$psName End"
