package com.kurukurupapa.tryandroid.fw;

import com.kurukurupapa.tryandroid.fw.util.LogUtil;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;

public abstract class BaseArrayAdapter<DtoT, ViewT extends View> extends
		ArrayAdapter<DtoT> {

	public BaseArrayAdapter(Context context) {
		super(context, 0);
	}

	/*
	 * (非 Javadoc)
	 *
	 * @see android.widget.ArrayAdapter#getView(int, android.view.View,
	 * android.view.ViewGroup)
	 */
	@Override
	public View getView(int position, View convertView, ViewGroup parent) {
		LogUtil.called();
		LogUtil.d("position=" + position + ",convertView=" + convertView
				+ ",parent=" + parent);

		// データ取得
		DtoT dto = getItem(position);

		// View取得
		ViewT view;
		if (convertView == null) {
			// View生成
			view = createView(getContext());
		} else {
			// Viewを使い回す
			view = (ViewT) convertView;
		}

		// 値を設定
		setData(dto, view);

		return view;
	}

	protected abstract ViewT createView(Context context);

	protected abstract void setData(DtoT dto, ViewT view);
}
