package com.kurukurupapa.tryandroid.fw;

import com.kurukurupapa.tryandroid.fw.util.LogUtil;
import com.kurukurupapa.tryandroid.fw.util.ReflectionUtil;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;

public class BroadcastReceiverAdapter extends BroadcastReceiver {
	private Object obj;
	private String methodName;

	public BroadcastReceiverAdapter(Object obj, String methodName) {
		this.obj = obj;
		this.methodName = methodName;
	}

	@Override
	public void onReceive(Context context, Intent intent) {
		LogUtil.called(getMethodFullName());
		ReflectionUtil.invokeMethod(obj, methodName, new Object[] { context,
				intent }, new Class<?>[] { Context.class, Intent.class });
	}

	private String getMethodFullName() {
		return obj.getClass().getName() + "#" + methodName;
	}
}
