﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.InteropServices;

namespace SleepCheck
{
    // winmm.dll（Windows Multimedia API）を使用したシステム日時アクセス用クラス
    class WinmmAdapter
    {
        [DllImport("winmm.dll", EntryPoint = "timeBeginPeriod")]
        public static extern uint TimeBeginPeriod(uint uMilliseconds);

        [DllImport("winmm.dll", EntryPoint = "timeEndPeriod")]
        public static extern uint TimeEndPeriod(uint uMilliseconds);

        [DllImport("winmm.dll", EntryPoint = "timeGetTime")]
        public static extern uint TimeGetTime();

        [DllImport("winmm.dll", EntryPoint = "timeGetDevCaps")]
        public static extern int TimeGetDevCaps(out TimeCaps ptc, int cbtc);

        // timer device capabilities data structure
        [StructLayout(LayoutKind.Sequential)]
        public struct TimeCaps
        {
            public int periodMin;          // minimum period supported
            public int periodMax;          // maximum period supported
        }

        public WinmmAdapter()
        {
            //uint time = TimeGetTime();

            //TimeCaps tc = new TimeCaps();
            //int result = TimeGetDevCaps(out tc, Marshal.SizeOf(typeof(TimeCaps)));
        }

        public TimeCaps GetTimeCaps()
        {
            TimeCaps tc = new TimeCaps();
            int result = TimeGetDevCaps(out tc, Marshal.SizeOf(typeof(TimeCaps)));
            return tc;
        }

        public void SetTimeBeginPeriod(uint milliseconds)
        {
            TimeBeginPeriod(milliseconds);
        }
    }
}
