/*
 * Decompiled with CFR 0.152.
 */
package com.kurukurupapa.tryandroid.fw.apt;

import com.kurukurupapa.tryandroid.fw.apt.MiniStringUtil;
import com.kurukurupapa.tryandroid.fw.apt.TaaId;
import javax.lang.model.element.Element;
import org.seasar.util.lang.StringUtil;

public class FieldData {
    private String srcType;
    private String srcName;
    private String dbType;
    private String dbName;
    private String dbInfo;
    private boolean idFlag;

    public FieldData() {
    }

    public FieldData(String type, String name, Element element) {
        if (name.equals("id") || element.getAnnotation(TaaId.class) != null) {
            this.idFlag = true;
        }
        this.setSrcType(type);
        this.setSrcName(name);
    }

    public void setSrcType(String srcType) {
        if ("java.lang.String".equals(srcType)) {
            srcType = "String";
        }
        this.srcType = StringUtil.capitalize((String)srcType);
        if (srcType.equals("boolean") || srcType.equals("short") || srcType.equals("int") || srcType.equals("long")) {
            this.dbType = "integer";
        } else if (srcType.equals("float") || srcType.equals("double")) {
            this.dbType = "real";
        } else if (srcType.equals("String")) {
            this.dbType = "text";
        } else {
            throw new RuntimeException("\u4e0d\u660e\u306a\u578b\u3067\u3059\u3002type=" + srcType);
        }
    }

    public void setSrcName(String srcName) {
        this.srcName = StringUtil.capitalize((String)srcName);
        this.dbName = MiniStringUtil.decamelizeAsLowerCase(srcName);
        this.dbInfo = this.idFlag ? "primary key autoincrement" : "not null";
    }

    public String getSrcType() {
        return this.srcType;
    }

    public String getSrcName() {
        return this.srcName;
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getDbType() {
        return this.dbType;
    }

    public String getDbInfo() {
        return this.dbInfo;
    }

    public boolean getIdFlag() {
        return this.idFlag;
    }
}

