/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.base.genfiles;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.X;
import java.io.Serializable;

public final class CharArray
implements Serializable {
    private static final long serialVersionUID = 1L;
    private char[] list;
    private int length;

    @Deprecated
    public CharArray() {
        this.list = new char[4];
        this.length = 0;
    }

    @Deprecated
    public CharArray(int capacity) {
        this.list = new char[capacity];
        this.length = 0;
    }

    public CharArray(char[] source, int start, int num) {
        X.assertTrue(num >= 0);
        this.list = new char[num];
        this.length = num;
        System.arraycopy(source, start, this.list, 0, num);
    }

    @Deprecated
    private CharArray(char[] array, int arrayLength) {
        this.list = array;
        this.length = arrayLength;
    }

    @Deprecated
    public static CharArray newInstance(char ... array) {
        Preconditions.checkNotNull(array);
        return new CharArray(array, array.length);
    }

    @Deprecated
    public static CharArray newInstance(char[] array, int length) {
        Preconditions.checkNotNull(array);
        Preconditions.checkArgument(length >= 0 && length <= array.length);
        return new CharArray(array, length);
    }

    public int size() {
        return this.length;
    }

    public char get(int i) {
        X.assertTrue(i >= 0 && i < this.length);
        return this.list[i];
    }

    public void set(int i, char x) {
        X.assertTrue(i >= 0 && i < this.length);
        this.list[i] = x;
    }

    public void add(char x) {
        if (this.length >= this.list.length) {
            this.ensureCapacity(this.length + 1);
        }
        this.list[this.length++] = x;
    }

    public void prependSlow(char x) {
        this.ensureCapacity(this.length + 1);
        System.arraycopy(this.list, 0, this.list, 1, this.length);
        this.list[0] = x;
        ++this.length;
    }

    public void add(char[] source, int start, int num) {
        if (this.length + num > this.list.length) {
            this.ensureCapacity(this.length + num);
        }
        System.arraycopy(source, start, this.list, this.length, num);
        this.length += num;
    }

    public void addArray(CharArray other) {
        this.add(other.rep(), 0, other.size());
    }

    public void clear() {
        this.length = 0;
    }

    public void removeLast() {
        X.assertTrue(this.length > 0);
        --this.length;
    }

    public char pop() {
        X.assertTrue(this.length > 0);
        return this.list[--this.length];
    }

    public void removeFast(int i) {
        X.assertTrue(i >= 0 && i < this.length);
        this.list[i] = this.list[this.length - 1];
        this.removeLast();
    }

    public int indexOf(char element) {
        for (int i = 0; i < this.length; ++i) {
            if (this.list[i] != element) continue;
            return i;
        }
        return -1;
    }

    public void removeSlow(int i) {
        X.assertTrue(i >= 0 && i < this.length);
        System.arraycopy(this.list, i + 1, this.list, i, this.length - (i + 1));
        --this.length;
    }

    public void replaceSlow(int start, int rangelen, CharArray other) {
        X.assertTrue(other.list != this.list);
        int end = start + rangelen;
        X.assertTrue(start >= 0 && end <= this.length);
        this.ensureCapacity(this.length - rangelen + other.length);
        if (end < this.length) {
            System.arraycopy(this.list, end, this.list, start + other.length, this.length - end);
        }
        System.arraycopy(other.list, 0, this.list, start, other.length);
        this.length = this.length - rangelen + other.length;
    }

    public void ensureCapacity(int n) {
        if (this.list.length < n) {
            int new_size = this.list.length * 2;
            if (new_size < n) {
                new_size = n;
            }
            char[] copy = new char[new_size];
            System.arraycopy(this.list, 0, copy, 0, this.length);
            this.list = copy;
        }
    }

    public char[] rep() {
        return this.list;
    }

    public void resize(int n) {
        X.assertTrue(n >= 0);
        this.ensureCapacity(n);
        this.length = n;
    }

    public void trimToSize() {
        if (this.list.length != this.length) {
            this.list = this.toArray();
        }
    }

    public void swap(CharArray other) {
        int tmp_length = this.length;
        this.length = other.length;
        other.length = tmp_length;
        char[] tmp_list = this.list;
        this.list = other.list;
        other.list = tmp_list;
    }

    public char[] toArray() {
        char[] copy = new char[this.length];
        System.arraycopy(this.list, 0, copy, 0, this.length);
        return copy;
    }

    public char[] subArray(int start, int len) {
        X.assertTrue(start >= 0);
        X.assertTrue(start + len <= this.length);
        char[] copy = new char[len];
        System.arraycopy(this.list, start, copy, 0, len);
        return copy;
    }

    public void copy(char[] dest, int len, int src_pos, int dest_pos) {
        X.assertTrue(src_pos >= 0);
        X.assertTrue(dest_pos >= 0);
        X.assertTrue(len >= 0);
        X.assertTrue(src_pos + len <= this.length);
        X.assertTrue(dest_pos + len <= dest.length);
        System.arraycopy(this.list, src_pos, dest, dest_pos, len);
    }
}

