/*
 * Decompiled with CFR 0.152.
 */
package javax.speech.recognition;

import java.util.Locale;
import javax.speech.EngineModeDesc;
import javax.speech.recognition.SpeakerProfile;

public class RecognizerModeDesc
extends EngineModeDesc {
    private Boolean dictationGrammarSupported;
    private SpeakerProfile[] profiles;

    public RecognizerModeDesc() {
        this.dictationGrammarSupported = null;
        this.profiles = null;
    }

    public RecognizerModeDesc(String string, String string2, Locale locale, Boolean bl, Boolean bl2, SpeakerProfile[] speakerProfileArray) {
        super(string, string2, locale, bl);
        this.dictationGrammarSupported = bl2;
        this.profiles = speakerProfileArray;
    }

    public RecognizerModeDesc(Locale locale, Boolean bl) {
        super(locale);
        this.dictationGrammarSupported = bl;
        this.profiles = null;
    }

    public synchronized void addSpeakerProfile(SpeakerProfile speakerProfile) {
        if (this.profiles == null) {
            this.profiles = new SpeakerProfile[1];
            this.profiles[0] = speakerProfile;
            return;
        }
        SpeakerProfile[] speakerProfileArray = new SpeakerProfile[this.profiles.length + 1];
        System.arraycopy(this.profiles, 0, speakerProfileArray, 0, this.profiles.length);
        speakerProfileArray[speakerProfileArray.length - 1] = speakerProfile;
        this.profiles = speakerProfileArray;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof RecognizerModeDesc)) {
            return false;
        }
        RecognizerModeDesc recognizerModeDesc = (RecognizerModeDesc)object;
        if (!super.equals(object)) {
            return false;
        }
        if (this.dictationGrammarSupported == null != (recognizerModeDesc.dictationGrammarSupported == null)) {
            return false;
        }
        if (this.dictationGrammarSupported != null && !this.dictationGrammarSupported.equals(recognizerModeDesc.dictationGrammarSupported)) {
            return false;
        }
        if (this.profiles == null != (recognizerModeDesc.profiles == null)) {
            return false;
        }
        if (this.profiles != null) {
            if (this.profiles.length != recognizerModeDesc.profiles.length) {
                return false;
            }
            int n = 0;
            while (n < this.profiles.length) {
                if (this.profiles[n] == null ? recognizerModeDesc.profiles[n] != null : !this.profiles[n].equals(recognizerModeDesc.profiles[n])) {
                    return false;
                }
                ++n;
            }
        }
        return true;
    }

    public final SpeakerProfile[] getSpeakerProfiles() throws SecurityException {
        return this.getSpeakerProfilesImpl();
    }

    protected SpeakerProfile[] getSpeakerProfilesImpl() {
        return this.profiles;
    }

    public Boolean isDictationGrammarSupported() {
        return this.dictationGrammarSupported;
    }

    public boolean match(EngineModeDesc engineModeDesc) {
        if (!super.match(engineModeDesc)) {
            return false;
        }
        if (!(engineModeDesc instanceof RecognizerModeDesc)) {
            return true;
        }
        RecognizerModeDesc recognizerModeDesc = (RecognizerModeDesc)engineModeDesc;
        if (recognizerModeDesc.dictationGrammarSupported != null && !recognizerModeDesc.dictationGrammarSupported.equals(this.dictationGrammarSupported)) {
            return false;
        }
        if (recognizerModeDesc.profiles != null && recognizerModeDesc.profiles.length > 0) {
            if (this.profiles == null) {
                return false;
            }
            int n = 0;
            while (n < recognizerModeDesc.profiles.length) {
                boolean bl = false;
                int n2 = 0;
                while (!bl && n2 < this.profiles.length) {
                    if (this.profiles[n2].match(recognizerModeDesc.profiles[n])) {
                        bl = true;
                    }
                    ++n2;
                }
                if (!bl) {
                    return false;
                }
                ++n;
            }
        }
        return true;
    }

    public void setDictationGrammarSupported(Boolean bl) {
        this.dictationGrammarSupported = bl;
    }

    public void setSpeakerProfiles(SpeakerProfile[] speakerProfileArray) {
        this.profiles = this.profiles;
    }
}

