/*
 * Decompiled with CFR 0.152.
 */
package javax.speech.recognition;

import javax.speech.recognition.Rule;
import javax.speech.recognition.RuleAlternatives;
import javax.speech.recognition.RuleToken;

public class RuleSequence
extends Rule {
    protected Rule[] rules;

    public RuleSequence() {
        this.setRules(null);
    }

    public RuleSequence(Rule rule) {
        Rule[] ruleArray = new Rule[]{rule};
        this.setRules(ruleArray);
    }

    public RuleSequence(String[] stringArray) {
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        this.rules = new Rule[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            this.rules[n] = new RuleToken(stringArray[n]);
            ++n;
        }
    }

    public RuleSequence(Rule[] ruleArray) {
        this.setRules(ruleArray);
    }

    public void append(Rule rule) {
        if (rule == null) {
            throw new NullPointerException("null rule to append");
        }
        int n = this.rules.length;
        Rule[] ruleArray = new Rule[n + 1];
        System.arraycopy(this.rules, 0, ruleArray, 0, n);
        ruleArray[n] = rule;
        this.rules = ruleArray;
    }

    public Rule copy() {
        Rule[] ruleArray = null;
        if (this.rules != null) {
            ruleArray = new Rule[this.rules.length];
            int n = 0;
            while (n < this.rules.length) {
                ruleArray[n] = this.rules[n].copy();
                ++n;
            }
        }
        return new RuleSequence(ruleArray);
    }

    public Rule[] getRules() {
        return this.rules;
    }

    public void setRules(Rule[] ruleArray) {
        if (ruleArray == null) {
            ruleArray = new Rule[]{};
        }
        this.rules = ruleArray;
    }

    public String toString() {
        if (this.rules.length == 0) {
            return "<NULL>";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.rules.length) {
            if (n > 0) {
                stringBuffer.append(' ');
            }
            if (this.rules[n] instanceof RuleAlternatives || this.rules[n] instanceof RuleSequence) {
                stringBuffer.append("( " + this.rules[n].toString() + " )");
            } else {
                stringBuffer.append(this.rules[n].toString());
            }
            ++n;
        }
        return stringBuffer.toString();
    }
}

