/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt;

import java.io.IOException;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.TypeElement;
import org.seasar.doma.internal.apt.AbstractGenerator;
import org.seasar.doma.internal.apt.meta.EntityMeta;
import org.seasar.doma.internal.apt.meta.EntityPropertyMeta;
import org.seasar.doma.internal.apt.meta.IdGeneratorMeta;
import org.seasar.doma.internal.apt.meta.IdGeneratorMetaVisitor;
import org.seasar.doma.internal.apt.meta.IdentityIdGeneratorMeta;
import org.seasar.doma.internal.apt.meta.OriginalStatesMeta;
import org.seasar.doma.internal.apt.meta.SequenceIdGeneratorMeta;
import org.seasar.doma.internal.apt.meta.TableIdGeneratorMeta;
import org.seasar.doma.internal.apt.type.BasicType;
import org.seasar.doma.internal.apt.type.DataType;
import org.seasar.doma.internal.apt.type.DomainType;
import org.seasar.doma.internal.apt.type.SimpleDataTypeVisitor;
import org.seasar.doma.internal.apt.type.WrapperType;
import org.seasar.doma.internal.jdbc.util.MetaTypeUtil;
import org.seasar.doma.internal.jdbc.util.TableUtil;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.entity.AbstractEntityType;
import org.seasar.doma.jdbc.entity.AssignedIdPropertyType;
import org.seasar.doma.jdbc.entity.BasicPropertyType;
import org.seasar.doma.jdbc.entity.EntityPropertyType;
import org.seasar.doma.jdbc.entity.GeneratedIdPropertyType;
import org.seasar.doma.jdbc.entity.NamingType;
import org.seasar.doma.jdbc.entity.OriginalStatesAccessor;
import org.seasar.doma.jdbc.entity.PostDeleteContext;
import org.seasar.doma.jdbc.entity.PostInsertContext;
import org.seasar.doma.jdbc.entity.PostUpdateContext;
import org.seasar.doma.jdbc.entity.PreDeleteContext;
import org.seasar.doma.jdbc.entity.PreInsertContext;
import org.seasar.doma.jdbc.entity.PreUpdateContext;
import org.seasar.doma.jdbc.entity.VersionPropertyType;

public class EntityTypeGenerator
extends AbstractGenerator {
    protected static final String NULL = "null";
    protected final EntityMeta entityMeta;

    public EntityTypeGenerator(ProcessingEnvironment env, TypeElement entityElement, EntityMeta entityMeta) throws IOException {
        super(env, entityElement, null, null, "_", "");
        AssertionUtil.assertNotNull(entityMeta);
        this.entityMeta = entityMeta;
    }

    @Override
    public void generate() {
        this.printPackage();
        this.printClass();
    }

    protected void printPackage() {
        if (!this.packageName.isEmpty()) {
            this.iprint("package %1$s;%n", this.packageName);
            this.iprint("%n", new Object[0]);
        }
    }

    protected void printClass() {
        this.iprint("/** */%n", new Object[0]);
        this.printGenerated();
        this.iprint("public final class %1$s extends %2$s<%3$s> {%n", this.simpleName, AbstractEntityType.class.getName(), this.entityMeta.getEntityTypeName());
        this.print("%n", new Object[0]);
        this.indent();
        this.printValidateVersionStaticInitializer();
        this.printFields();
        this.printConstructor();
        this.printMethods();
        this.unindent();
        this.iprint("}%n", new Object[0]);
    }

    protected void printFields() {
        this.printSingletonField();
        this.printOriginalStatesAccessorField();
        this.printIdGeneratorField();
        this.printPropertyTypeFields();
        this.printListenerField();
        this.printNamingTypeField();
        this.printCatalogNameField();
        this.printSchemaNameField();
        this.printTableNameField();
        this.printQualifiedTableNameField();
        this.printNameField();
        this.printIdPropertyTypesField();
        this.printEntityPropertyTypesField();
        this.printEntityPropertyTypeMapField();
    }

    protected void printSingletonField() {
        this.iprint("private static final %1$s __singleton = new %1$s();%n", this.simpleName);
        this.print("%n", new Object[0]);
    }

    protected void printOriginalStatesAccessorField() {
        if (!this.entityMeta.isAbstract() && this.entityMeta.hasOriginalStatesMeta()) {
            OriginalStatesMeta osm = this.entityMeta.getOriginalStatesMeta();
            this.iprint("private static final %1$s<%2$s> __originalStatesAccessor = new %1$s<%2$s>(%2$s.class, \"%3$s\");%n", OriginalStatesAccessor.class.getName(), osm.getEntityTypeName(), osm.getName());
            this.print("%n", new Object[0]);
        }
    }

    protected void printIdGeneratorField() {
        if (this.entityMeta.hasGeneratedIdPropertyMeta()) {
            EntityPropertyMeta propertyMeta = this.entityMeta.getGeneratedIdPropertyMeta();
            IdGeneratorMeta idGeneratorMeta = propertyMeta.getIdGeneratorMeta();
            idGeneratorMeta.accept(new IdGeneratorGenerator(), null);
            this.print("%n", new Object[0]);
        }
    }

    protected void printPropertyTypeFields() {
        for (EntityPropertyMeta pm : this.entityMeta.getAllPropertyMetas()) {
            class Visitor
            extends SimpleDataTypeVisitor<Void, Void, RuntimeException> {
                WrapperType wrapperType;
                DomainType domainType;

                Visitor() {
                }

                @Override
                protected Void defaultAction(DataType dataType, Void p) throws RuntimeException {
                    return (Void)AssertionUtil.assertUnreachable();
                }

                @Override
                public Void visitBasicType(BasicType basicType, Void p) throws RuntimeException {
                    this.wrapperType = basicType.getWrapperType();
                    return null;
                }

                @Override
                public Void visitDomainType(DomainType domainType, Void p) throws RuntimeException {
                    this.domainType = domainType;
                    this.wrapperType = domainType.getBasicType().getWrapperType();
                    return null;
                }
            }
            Visitor visitor = new Visitor();
            pm.getDataType().accept(visitor, null);
            String parentEntityPropertyType = NULL;
            String parentEntityTypeNameAsTypeParameter = Object.class.getName();
            if (!pm.isOwnProperty()) {
                parentEntityPropertyType = this.getMetaTypeName(pm.getEntityTypeName()) + ".getSingletonInternal()." + pm.getName();
                parentEntityTypeNameAsTypeParameter = pm.getEntityTypeName();
            }
            String domainType = NULL;
            String domainTypeNameAsTypeParameter = Object.class.getName();
            if (visitor.domainType != null) {
                domainType = this.getMetaTypeName(visitor.domainType.getTypeName()) + ".getSingletonInternal()";
                domainTypeNameAsTypeParameter = visitor.domainType.getTypeNameAsTypeParameter();
            }
            this.iprint("/** the %1$s */%n", pm.getName());
            if (pm.isId()) {
                if (pm.getIdGeneratorMeta() != null) {
                    this.iprint("public final %1$s<%11$s, %2$s, %3$s, %9$s> %4$s = new %1$s<%11$s, %2$s, %3$s, %9$s>(%6$s.class, %3$s.class, %7$s.class, %10$s, %8$s, \"%4$s\", \"%5$s\", __idGenerator);%n", GeneratedIdPropertyType.class.getName(), this.entityMeta.getEntityTypeName(), visitor.wrapperType.getWrappedType().getTypeNameAsTypeParameter(), pm.getName(), pm.getColumnName(), this.entityMeta.getEntityTypeName(), visitor.wrapperType.getQualifiedName(), domainType, domainTypeNameAsTypeParameter, parentEntityPropertyType, parentEntityTypeNameAsTypeParameter);
                } else {
                    this.iprint("public final %1$s<%11$s, %2$s, %3$s, %9$s> %4$s = new %1$s<%11$s, %2$s, %3$s, %9$s>(%6$s.class, %3$s.class, %7$s.class, %10$s, %8$s, \"%4$s\", \"%5$s\");%n", AssignedIdPropertyType.class.getName(), this.entityMeta.getEntityTypeName(), visitor.wrapperType.getWrappedType().getTypeNameAsTypeParameter(), pm.getName(), pm.getColumnName(), this.entityMeta.getEntityTypeName(), visitor.wrapperType.getQualifiedName(), domainType, domainTypeNameAsTypeParameter, parentEntityPropertyType, parentEntityTypeNameAsTypeParameter);
                }
            } else if (pm.isVersion()) {
                this.iprint("public final %1$s<%11$s, %2$s, %3$s, %9$s> %4$s = new %1$s<%11$s, %2$s, %3$s, %9$s>(%6$s.class, %3$s.class, %7$s.class, %10$s, %8$s, \"%4$s\", \"%5$s\");%n", VersionPropertyType.class.getName(), this.entityMeta.getEntityTypeName(), visitor.wrapperType.getWrappedType().getTypeNameAsTypeParameter(), pm.getName(), pm.getColumnName(), this.entityMeta.getEntityTypeName(), visitor.wrapperType.getQualifiedName(), domainType, domainTypeNameAsTypeParameter, parentEntityPropertyType, parentEntityTypeNameAsTypeParameter);
            } else {
                this.iprint("public final %1$s<%13$s, %2$s, %3$s, %11$s> %4$s = new %1$s<%13$s, %2$s, %3$s, %11$s>(%8$s.class, %3$s.class, %9$s.class, %12$s, %10$s, \"%4$s\", \"%5$s\", %6$s, %7$s);%n", BasicPropertyType.class.getName(), this.entityMeta.getEntityTypeName(), visitor.wrapperType.getWrappedType().getTypeNameAsTypeParameter(), pm.getName(), pm.getColumnName(), pm.isColumnInsertable(), pm.isColumnUpdatable(), this.entityMeta.getEntityTypeName(), visitor.wrapperType.getQualifiedName(), domainType, domainTypeNameAsTypeParameter, parentEntityPropertyType, parentEntityTypeNameAsTypeParameter);
            }
            this.print("%n", new Object[0]);
        }
    }

    protected void printListenerField() {
        this.iprint("private final %1$s __listener;%n", this.entityMeta.getEntityListener());
        this.print("%n", new Object[0]);
    }

    protected void printNamingTypeField() {
        this.iprint("private final %1$s __namingType;%n", NamingType.class.getName());
        this.print("%n", new Object[0]);
    }

    protected void printCatalogNameField() {
        this.iprint("private final String __catalogName;%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected void printSchemaNameField() {
        this.iprint("private final String __schemaName;%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected void printTableNameField() {
        this.iprint("private final String __tableName;%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected void printQualifiedTableNameField() {
        this.iprint("private final String __qualifiedTableName;%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected void printNameField() {
        this.iprint("private final String __name;%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected void printIdPropertyTypesField() {
        this.iprint("private final java.util.List<%1$s<%2$s, ?>> __idPropertyTypes;%n", EntityPropertyType.class.getName(), this.entityMeta.getEntityTypeName());
        this.print("%n", new Object[0]);
    }

    protected void printEntityPropertyTypesField() {
        this.iprint("private final java.util.List<%1$s<%2$s, ?>> __entityPropertyTypes;%n", EntityPropertyType.class.getName(), this.entityMeta.getEntityTypeName());
        this.print("%n", new Object[0]);
    }

    protected void printEntityPropertyTypeMapField() {
        this.iprint("private final java.util.Map<String, %1$s<%2$s, ?>> __entityPropertyTypeMap;%n", EntityPropertyType.class.getName(), this.entityMeta.getEntityTypeName());
        this.print("%n", new Object[0]);
    }

    protected void printConstructor() {
        this.iprint("private %1$s() {%n", this.simpleName);
        this.iprint("    __listener = new %1$s();%n", this.entityMeta.getEntityListener());
        this.iprint("    __namingType = %1$s.%2$s;%n", NamingType.class.getName(), this.entityMeta.getNamingType().name());
        this.iprint("    __name = \"%1$s\";%n", this.entityMeta.getEntityName());
        this.iprint("    __catalogName = \"%1$s\";%n", this.entityMeta.getCatalogName());
        this.iprint("    __schemaName = \"%1$s\";%n", this.entityMeta.getSchemaName());
        this.iprint("    __tableName = \"%1$s\";%n", this.entityMeta.getTableName());
        this.iprint("    __qualifiedTableName = \"%1$s\";%n", TableUtil.getQualifiedTableName(this.entityMeta.getCatalogName(), this.entityMeta.getSchemaName(), this.entityMeta.getTableName()));
        this.iprint("    java.util.List<%1$s<%2$s, ?>> __idList = new java.util.ArrayList<%1$s<%2$s, ?>>();%n", EntityPropertyType.class.getName(), this.entityMeta.getEntityTypeName());
        this.iprint("    java.util.List<%1$s<%2$s, ?>> __list = new java.util.ArrayList<%1$s<%2$s, ?>>(%3$s);%n", EntityPropertyType.class.getName(), this.entityMeta.getEntityTypeName(), this.entityMeta.getAllPropertyMetas().size());
        this.iprint("    java.util.Map<String, %1$s<%2$s, ?>> __map = new java.util.HashMap<String, %1$s<%2$s, ?>>(%3$s);%n", EntityPropertyType.class.getName(), this.entityMeta.getEntityTypeName(), this.entityMeta.getAllPropertyMetas().size());
        for (EntityPropertyMeta pm : this.entityMeta.getAllPropertyMetas()) {
            if (pm.isId()) {
                this.iprint("    __idList.add(%1$s);%n", pm.getName());
            }
            this.iprint("    __list.add(%1$s);%n", pm.getName());
            this.iprint("    __map.put(\"%1$s\", %1$s);%n", pm.getName());
        }
        this.iprint("    __idPropertyTypes = java.util.Collections.unmodifiableList(__idList);%n", new Object[0]);
        this.iprint("    __entityPropertyTypes = java.util.Collections.unmodifiableList(__list);%n", new Object[0]);
        this.iprint("    __entityPropertyTypeMap = java.util.Collections.unmodifiableMap(__map);%n", new Object[0]);
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected void printMethods() {
        this.printGetNamingTypeMethod();
        this.printGetNameMethod();
        this.printGetCatalogNameMethod();
        this.printGetSchemaNameMethod();
        this.printGetTableNameMethod();
        this.printGetQualifiedTableNameMethod();
        this.printPreInsertMethod();
        this.printPreUpdateMethod();
        this.printPreDeleteMethod();
        this.printPostInsertMethod();
        this.printPostUpdateMethod();
        this.printPostDeleteMethod();
        this.printGetEntityPropertyTypesMethod();
        this.printGetEntityPropertyTypeMethod();
        this.printGetIdPropertyTypesMethod();
        this.printGetGeneratedIdPropertyTypeMethod();
        this.printGetVersionPropertyTypeMethod();
        this.printNewEntityMethod();
        this.printGetEntityClassMethod();
        this.printGetOriginalStatesMethod();
        this.printSaveCurrentStatesMethod();
        this.printGetSingletonInternalMethod();
        this.printNewInstanceMethod();
    }

    protected void printGetNamingTypeMethod() {
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public %1$s getNamingType() {%n", NamingType.class.getName());
        this.iprint("    return __namingType;%n", new Object[0]);
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected void printGetNameMethod() {
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public String getName() {%n", new Object[0]);
        this.iprint("    return __name;%n", new Object[0]);
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected void printGetCatalogNameMethod() {
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public String getCatalogName() {%n", new Object[0]);
        this.iprint("    return __catalogName;%n", new Object[0]);
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected void printGetSchemaNameMethod() {
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public String getSchemaName() {%n", new Object[0]);
        this.iprint("    return __schemaName;%n", new Object[0]);
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected void printGetTableNameMethod() {
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public String getTableName() {%n", new Object[0]);
        this.iprint("    return __tableName;%n", new Object[0]);
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected void printGetQualifiedTableNameMethod() {
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public String getQualifiedTableName() {%n", new Object[0]);
        this.iprint("    return __qualifiedTableName;%n", new Object[0]);
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected void printPreInsertMethod() {
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public void preInsert(%1$s entity, %2$s context) {%n", this.entityMeta.getEntityTypeName(), PreInsertContext.class.getName());
        this.iprint("    __listener.preInsert(entity, context);%n", new Object[0]);
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected void printPreUpdateMethod() {
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public void preUpdate(%1$s entity, %2$s context) {%n", this.entityMeta.getEntityTypeName(), PreUpdateContext.class.getName());
        this.iprint("    __listener.preUpdate(entity, context);%n", new Object[0]);
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected void printPreDeleteMethod() {
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public void preDelete(%1$s entity, %2$s context) {%n", this.entityMeta.getEntityTypeName(), PreDeleteContext.class.getName());
        this.iprint("    __listener.preDelete(entity, context);%n", new Object[0]);
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected void printPostInsertMethod() {
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public void postInsert(%1$s entity, %2$s context) {%n", this.entityMeta.getEntityTypeName(), PostInsertContext.class.getName());
        this.iprint("    __listener.postInsert(entity, context);%n", new Object[0]);
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected void printPostUpdateMethod() {
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public void postUpdate(%1$s entity, %2$s context) {%n", this.entityMeta.getEntityTypeName(), PostUpdateContext.class.getName());
        this.iprint("    __listener.postUpdate(entity, context);%n", new Object[0]);
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected void printPostDeleteMethod() {
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public void postDelete(%1$s entity, %2$s context) {%n", this.entityMeta.getEntityTypeName(), PostDeleteContext.class.getName());
        this.iprint("    __listener.postDelete(entity, context);%n", new Object[0]);
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected void printGetEntityPropertyTypesMethod() {
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public java.util.List<%1$s<%2$s, ?>> getEntityPropertyTypes() {%n", EntityPropertyType.class.getName(), this.entityMeta.getEntityTypeName());
        this.iprint("    return __entityPropertyTypes;%n", new Object[0]);
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected void printGetEntityPropertyTypeMethod() {
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public %1$s<%2$s, ?> getEntityPropertyType(String __name) {%n", EntityPropertyType.class.getName(), this.entityMeta.getEntityTypeName());
        this.iprint("    return __entityPropertyTypeMap.get(__name);%n", new Object[0]);
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected void printGetIdPropertyTypesMethod() {
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public java.util.List<%1$s<%2$s, ?>> getIdPropertyTypes() {%n", EntityPropertyType.class.getName(), this.entityMeta.getEntityTypeName());
        this.iprint("    return __idPropertyTypes;%n", new Object[0]);
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected void printGetGeneratedIdPropertyTypeMethod() {
        String parentEntityTypeNameAsTypeParameter = Object.class.getName();
        String idName = NULL;
        if (this.entityMeta.hasGeneratedIdPropertyMeta()) {
            EntityPropertyMeta pm = this.entityMeta.getGeneratedIdPropertyMeta();
            idName = pm.getName();
            if (!pm.isOwnProperty()) {
                parentEntityTypeNameAsTypeParameter = pm.getEntityTypeName();
            }
        }
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public %1$s<%3$s, %2$s, ?, ?> getGeneratedIdPropertyType() {%n", GeneratedIdPropertyType.class.getName(), this.entityMeta.getEntityTypeName(), parentEntityTypeNameAsTypeParameter);
        this.iprint("    return %1$s;%n", idName);
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected void printGetVersionPropertyTypeMethod() {
        String parentEntityTypeNameAsTypeParameter = Object.class.getName();
        String versionName = NULL;
        if (this.entityMeta.hasVersionPropertyMeta()) {
            EntityPropertyMeta pm = this.entityMeta.getVersionPropertyMeta();
            versionName = pm.getName();
            if (!pm.isOwnProperty()) {
                parentEntityTypeNameAsTypeParameter = pm.getEntityTypeName();
            }
        }
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public %1$s<%3$s, %2$s, ?, ?> getVersionPropertyType() {%n", VersionPropertyType.class.getName(), this.entityMeta.getEntityTypeName(), parentEntityTypeNameAsTypeParameter);
        this.iprint("    return %1$s;%n", versionName);
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected void printNewEntityMethod() {
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public %1$s newEntity() {%n", this.entityMeta.getEntityTypeName());
        if (this.entityMeta.isAbstract()) {
            this.iprint("    return null;%n", new Object[0]);
        } else {
            this.iprint("    return new %1$s();%n", this.entityMeta.getEntityTypeName());
        }
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected void printGetEntityClassMethod() {
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public Class<%1$s> getEntityClass() {%n", this.entityMeta.getEntityTypeName());
        this.iprint("    return %1$s.class;%n", this.entityMeta.getEntityTypeName());
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected void printGetOriginalStatesMethod() {
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public %1$s getOriginalStates(%1$s __entity) {%n", this.entityMeta.getEntityTypeName());
        if (!this.entityMeta.isAbstract() && this.entityMeta.hasOriginalStatesMeta()) {
            this.iprint("    return __originalStatesAccessor.get(__entity);%n", new Object[0]);
        } else {
            this.iprint("    return null;%n", new Object[0]);
        }
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected void printSaveCurrentStatesMethod() {
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public void saveCurrentStates(%1$s __entity) {%n", this.entityMeta.getEntityTypeName());
        if (!this.entityMeta.isAbstract() && this.entityMeta.hasOriginalStatesMeta()) {
            this.iprint("    %1$s __currentStates = new %1$s();%n", this.entityMeta.getEntityTypeName());
            for (EntityPropertyMeta pm : this.entityMeta.getAllPropertyMetas()) {
                this.iprint("    %1$s.getWrapper(__currentStates).set(%1$s.getWrapper(__entity).getCopy());%n", pm.getName());
            }
            this.iprint("    __originalStatesAccessor.set(__entity, __currentStates);%n", new Object[0]);
        }
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected void printGetSingletonInternalMethod() {
        this.iprint("/**%n", new Object[0]);
        this.iprint(" * @return the singleton%n", new Object[0]);
        this.iprint(" */%n", new Object[0]);
        this.iprint("public static %1$s getSingletonInternal() {%n", this.simpleName);
        this.iprint("    return __singleton;%n", new Object[0]);
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected void printNewInstanceMethod() {
        this.iprint("/**%n", new Object[0]);
        this.iprint(" * @return the new instance%n", new Object[0]);
        this.iprint(" */%n", new Object[0]);
        this.iprint("public static %1$s newInstance() {%n", this.simpleName);
        this.iprint("    return new %1$s();%n", this.simpleName);
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected String getMetaTypeName(String qualifiedName) {
        return MetaTypeUtil.getMetaTypeName(qualifiedName);
    }

    protected class IdGeneratorGenerator
    implements IdGeneratorMetaVisitor<Void, Void> {
        protected IdGeneratorGenerator() {
        }

        @Override
        public Void visistIdentityIdGeneratorMeta(IdentityIdGeneratorMeta m, Void p) {
            EntityTypeGenerator.this.iprint("private final %1$s __idGenerator = new %1$s();%n", m.getIdGeneratorClassName());
            return null;
        }

        @Override
        public Void visistSequenceIdGeneratorMeta(SequenceIdGeneratorMeta m, Void p) {
            EntityTypeGenerator.this.iprint("private final %1$s __idGenerator = new %1$s();%n", m.getIdGeneratorClassName());
            EntityTypeGenerator.this.iprint("{%n", new Object[0]);
            EntityTypeGenerator.this.iprint("    __idGenerator.setQualifiedSequenceName(\"%1$s\");%n", m.getQualifiedSequenceName());
            EntityTypeGenerator.this.iprint("    __idGenerator.setInitialValue(%1$s);%n", m.getInitialValue());
            EntityTypeGenerator.this.iprint("    __idGenerator.setAllocationSize(%1$s);%n", m.getAllocationSize());
            EntityTypeGenerator.this.iprint("    __idGenerator.initialize();%n", new Object[0]);
            EntityTypeGenerator.this.iprint("}%n", new Object[0]);
            return null;
        }

        @Override
        public Void visistTableIdGeneratorMeta(TableIdGeneratorMeta m, Void p) {
            EntityTypeGenerator.this.iprint("private final %1$s __idGenerator = new %1$s();%n", m.getIdGeneratorClassName());
            EntityTypeGenerator.this.iprint("{%n", new Object[0]);
            EntityTypeGenerator.this.iprint("    __idGenerator.setQualifiedTableName(\"%1$s\");%n", m.getQualifiedTableName());
            EntityTypeGenerator.this.iprint("    __idGenerator.setInitialValue(%1$s);%n", m.getInitialValue());
            EntityTypeGenerator.this.iprint("    __idGenerator.setAllocationSize(%1$s);%n", m.getAllocationSize());
            EntityTypeGenerator.this.iprint("    __idGenerator.setPkColumnName(\"%1$s\");%n", m.getPkColumnName());
            EntityTypeGenerator.this.iprint("    __idGenerator.setPkColumnValue(\"%1$s\");%n", m.getPkColumnValue());
            EntityTypeGenerator.this.iprint("    __idGenerator.setValueColumnName(\"%1$s\");%n", m.getValueColumnName());
            EntityTypeGenerator.this.iprint("    __idGenerator.initialize();%n", new Object[0]);
            EntityTypeGenerator.this.iprint("}%n", new Object[0]);
            return null;
        }
    }
}

