/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.decl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.decl.ConstructorDeclaration;
import org.seasar.doma.internal.apt.decl.FieldDeclaration;
import org.seasar.doma.internal.apt.decl.MethodDeclaration;
import org.seasar.doma.internal.apt.decl.TypeParameterDeclaration;
import org.seasar.doma.internal.apt.util.ElementUtil;
import org.seasar.doma.internal.apt.util.TypeMirrorUtil;
import org.seasar.doma.internal.util.AssertionUtil;

public class TypeDeclaration {
    protected static final Map<String, Integer> NUMBER_PRIORITY_MAP = new HashMap<String, Integer>();
    protected TypeElement typeElement;
    protected TypeMirror type;
    protected Map<String, List<TypeParameterDeclaration>> typeParameterDeclarationsMap = new HashMap<String, List<TypeParameterDeclaration>>();
    protected ProcessingEnvironment env;
    protected int numberPriority;

    protected TypeDeclaration() {
    }

    public TypeMirror getType() {
        return this.type;
    }

    public ProcessingEnvironment getProcessingEnvironment() {
        return this.env;
    }

    public String getQualifiedName() {
        if (this.typeElement == null) {
            return ((Object)this.type).toString();
        }
        return this.typeElement.getQualifiedName().toString();
    }

    public boolean isUnknownType() {
        return this.type.getKind() == TypeKind.NONE;
    }

    public boolean isNullType() {
        return this.type.getKind() == TypeKind.NULL;
    }

    public boolean isBooleanType() {
        return this.type.getKind() == TypeKind.BOOLEAN || TypeMirrorUtil.isSameType(this.type, Boolean.class, this.env);
    }

    public boolean isTextType() {
        return this.type.getKind() == TypeKind.CHAR || TypeMirrorUtil.isSameType(this.type, String.class, this.env) || TypeMirrorUtil.isSameType(this.type, Character.class, this.env);
    }

    public boolean isNumberType() {
        switch (this.type.getKind()) {
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                return true;
            }
        }
        TypeElement typeElement = TypeMirrorUtil.toTypeElement(this.type, this.env);
        if (typeElement == null) {
            return false;
        }
        return NUMBER_PRIORITY_MAP.containsKey(typeElement.getQualifiedName().toString());
    }

    public int getNumberPriority() {
        return this.numberPriority;
    }

    public List<ConstructorDeclaration> getConstructorDeclarations(List<TypeDeclaration> parameterTypeDeclarations) {
        List<ConstructorDeclaration> candidates = this.getCandidateConstructorDeclarations(parameterTypeDeclarations);
        if (candidates.size() == 1) {
            return candidates;
        }
        ConstructorDeclaration constructorDeclaration = this.findSuitableConstructorDeclaration(parameterTypeDeclarations, candidates);
        if (constructorDeclaration != null) {
            return Collections.singletonList(constructorDeclaration);
        }
        return candidates;
    }

    protected List<ConstructorDeclaration> getCandidateConstructorDeclarations(List<TypeDeclaration> parameterTypeDeclarations) {
        LinkedList<ConstructorDeclaration> results = new LinkedList<ConstructorDeclaration>();
        for (Map.Entry<String, List<TypeParameterDeclaration>> e : this.typeParameterDeclarationsMap.entrySet()) {
            String typeQualifiedName = e.getKey();
            List<TypeParameterDeclaration> typeParameterDeclarations = e.getValue();
            TypeElement typeElement = ElementUtil.getTypeElement(typeQualifiedName, this.env);
            block1: for (ExecutableElement constructor : ElementFilter.constructorsIn(typeElement.getEnclosedElements())) {
                List<? extends VariableElement> parameters;
                if (!constructor.getModifiers().contains((Object)Modifier.PUBLIC) || (parameters = constructor.getParameters()).size() != parameterTypeDeclarations.size()) continue;
                Iterator<TypeDeclaration> typeDeclIterator = parameterTypeDeclarations.iterator();
                Iterator<? extends VariableElement> valueElementIterator = parameters.iterator();
                while (typeDeclIterator.hasNext() && valueElementIterator.hasNext()) {
                    TypeMirror t2;
                    TypeMirror t1 = TypeMirrorUtil.boxIfPrimitive(typeDeclIterator.next().getType(), this.env);
                    if (TypeMirrorUtil.isAssignable(t1, t2 = TypeMirrorUtil.boxIfPrimitive(valueElementIterator.next().asType(), this.env), this.env)) continue;
                    continue block1;
                }
                ConstructorDeclaration constructorDeclaration = ConstructorDeclaration.newInstance(constructor, typeParameterDeclarations, this.env);
                results.add(constructorDeclaration);
            }
        }
        return results;
    }

    protected ConstructorDeclaration findSuitableConstructorDeclaration(List<TypeDeclaration> parameterTypeDeclarations, List<ConstructorDeclaration> candidates) {
        block0: for (ConstructorDeclaration constructorDeclaration : candidates) {
            Iterator<TypeDeclaration> typeDeclIterator = parameterTypeDeclarations.iterator();
            Iterator<? extends VariableElement> valueElementIterator = constructorDeclaration.getElement().getParameters().iterator();
            while (typeDeclIterator.hasNext() && valueElementIterator.hasNext()) {
                TypeMirror t2;
                TypeMirror t1 = TypeMirrorUtil.boxIfPrimitive(typeDeclIterator.next().getType(), this.env);
                if (TypeMirrorUtil.isSameType(t1, t2 = TypeMirrorUtil.boxIfPrimitive(valueElementIterator.next().asType(), this.env), this.env)) continue;
                continue block0;
            }
            return constructorDeclaration;
        }
        return null;
    }

    public FieldDeclaration getFieldDeclaration(String name) {
        return this.getFieldDeclarationInternal(name, false);
    }

    public FieldDeclaration getStaticFieldDeclaration(String name) {
        return this.getFieldDeclarationInternal(name, true);
    }

    public FieldDeclaration getFieldDeclarationInternal(String name, boolean statik) {
        List<FieldDeclaration> candidates = this.getCandidateFieldDeclaration(name, statik);
        this.removeHiddenFieldDeclarations(candidates);
        if (candidates.size() == 0) {
            return null;
        }
        if (candidates.size() == 1) {
            return candidates.get(0);
        }
        throw new AptIllegalStateException(name);
    }

    public List<FieldDeclaration> getCandidateFieldDeclaration(String name, boolean statik) {
        LinkedList<FieldDeclaration> results = new LinkedList<FieldDeclaration>();
        for (Map.Entry<String, List<TypeParameterDeclaration>> e : this.typeParameterDeclarationsMap.entrySet()) {
            String typeQualifiedName = e.getKey();
            List<TypeParameterDeclaration> typeParameterDeclarations = e.getValue();
            TypeElement typeElement = ElementUtil.getTypeElement(typeQualifiedName, this.env);
            for (VariableElement field : ElementFilter.fieldsIn(typeElement.getEnclosedElements())) {
                if (statik && !field.getModifiers().contains((Object)Modifier.STATIC) || !field.getSimpleName().contentEquals(name)) continue;
                FieldDeclaration fieldDeclaration = FieldDeclaration.newInstance(field, typeParameterDeclarations, this.env);
                results.add(fieldDeclaration);
            }
        }
        return results;
    }

    protected void removeHiddenFieldDeclarations(List<FieldDeclaration> candidates) {
        LinkedList<FieldDeclaration> hiders = new LinkedList<FieldDeclaration>(candidates);
        Iterator<FieldDeclaration> it = candidates.iterator();
        while (it.hasNext()) {
            FieldDeclaration hidden = it.next();
            for (FieldDeclaration hider : hiders) {
                if (!this.env.getElementUtils().hides(hider.getElement(), hidden.getElement())) continue;
                it.remove();
            }
        }
    }

    public List<MethodDeclaration> getMethodDeclarations(String name, List<TypeDeclaration> parameterTypeDeclarations) {
        return this.getMethodDeclarationsInternal(name, parameterTypeDeclarations, false);
    }

    public List<MethodDeclaration> getStaticMethodDeclarations(String name, List<TypeDeclaration> parameterTypeDeclarations) {
        return this.getMethodDeclarationsInternal(name, parameterTypeDeclarations, true);
    }

    protected List<MethodDeclaration> getMethodDeclarationsInternal(String name, List<TypeDeclaration> parameterTypeDeclarations, boolean statik) {
        List<MethodDeclaration> candidates = this.getCandidateMethodDeclarations(name, parameterTypeDeclarations, statik);
        this.removeOverriddenMethodDeclarations(candidates);
        this.removeHiddenMethodDeclarations(candidates);
        if (candidates.size() == 1) {
            return candidates;
        }
        MethodDeclaration suitableMethodDeclaration = this.findSuitableMethodDeclaration(parameterTypeDeclarations, candidates);
        if (suitableMethodDeclaration != null) {
            return Collections.singletonList(suitableMethodDeclaration);
        }
        return candidates;
    }

    protected List<MethodDeclaration> getCandidateMethodDeclarations(String name, List<TypeDeclaration> parameterTypeDeclarations, boolean statik) {
        LinkedList<MethodDeclaration> results = new LinkedList<MethodDeclaration>();
        for (Map.Entry<String, List<TypeParameterDeclaration>> e : this.typeParameterDeclarationsMap.entrySet()) {
            String typeQualifiedName = e.getKey();
            List<TypeParameterDeclaration> typeParameterDeclarations = e.getValue();
            TypeElement typeElement = ElementUtil.getTypeElement(typeQualifiedName, this.env);
            block1: for (ExecutableElement method : ElementFilter.methodsIn(typeElement.getEnclosedElements())) {
                if (statik && !method.getModifiers().contains((Object)Modifier.STATIC) || !method.getModifiers().contains((Object)Modifier.PUBLIC) || !method.getSimpleName().contentEquals(name) || method.getReturnType().getKind() == TypeKind.VOID) continue;
                List<? extends VariableElement> parameters = method.getParameters();
                if (method.getParameters().size() != parameterTypeDeclarations.size()) continue;
                Iterator<TypeDeclaration> typeDeclIterator = parameterTypeDeclarations.iterator();
                Iterator<? extends VariableElement> valueElementIterator = parameters.iterator();
                while (typeDeclIterator.hasNext() && valueElementIterator.hasNext()) {
                    TypeMirror t2;
                    TypeMirror t1 = TypeMirrorUtil.boxIfPrimitive(typeDeclIterator.next().getType(), this.env);
                    if (TypeMirrorUtil.isAssignable(t1, t2 = TypeMirrorUtil.boxIfPrimitive(valueElementIterator.next().asType(), this.env), this.env)) continue;
                    continue block1;
                }
                MethodDeclaration methodDeclaration = MethodDeclaration.newInstance(method, typeParameterDeclarations, this.env);
                results.add(methodDeclaration);
            }
        }
        return results;
    }

    protected void removeOverriddenMethodDeclarations(List<MethodDeclaration> candidates) {
        LinkedList<MethodDeclaration> overriders = new LinkedList<MethodDeclaration>(candidates);
        Iterator<MethodDeclaration> it = candidates.iterator();
        while (it.hasNext()) {
            MethodDeclaration overridden = it.next();
            for (MethodDeclaration overrider : overriders) {
                if (this.typeElement.equals(overrider.getElement().getEnclosingElement()) || !this.env.getElementUtils().overrides(overrider.getElement(), overridden.getElement(), this.typeElement)) continue;
                it.remove();
            }
        }
    }

    protected void removeHiddenMethodDeclarations(List<MethodDeclaration> candidates) {
        LinkedList<MethodDeclaration> hiders = new LinkedList<MethodDeclaration>(candidates);
        Iterator<MethodDeclaration> it = candidates.iterator();
        while (it.hasNext()) {
            MethodDeclaration hidden = it.next();
            for (MethodDeclaration hider : hiders) {
                TypeMirror supertype;
                TypeMirror subtype = hider.getElement().getEnclosingElement().asType();
                if (!TypeMirrorUtil.isAssignable(subtype, supertype = hidden.getElement().getEnclosingElement().asType(), this.env) || !this.env.getElementUtils().hides(hider.getElement(), hidden.getElement())) continue;
                it.remove();
            }
        }
    }

    protected MethodDeclaration findSuitableMethodDeclaration(List<TypeDeclaration> parameterTypeDeclarations, List<MethodDeclaration> candidates) {
        block0: for (MethodDeclaration methodDeclaration : candidates) {
            Iterator<TypeDeclaration> typeDeclIterator = parameterTypeDeclarations.iterator();
            Iterator<? extends VariableElement> valueElementIterator = methodDeclaration.getElement().getParameters().iterator();
            while (typeDeclIterator.hasNext() && valueElementIterator.hasNext()) {
                TypeMirror t2;
                TypeMirror t1 = TypeMirrorUtil.boxIfPrimitive(typeDeclIterator.next().getType(), this.env);
                if (TypeMirrorUtil.isSameType(t1, t2 = TypeMirrorUtil.boxIfPrimitive(valueElementIterator.next().asType(), this.env), this.env)) continue;
                continue block0;
            }
            return methodDeclaration;
        }
        return null;
    }

    public TypeDeclaration emulateConcatOperation(TypeDeclaration other) {
        AssertionUtil.assertNotNull(other);
        AssertionUtil.assertTrue(this.isTextType(), new Object[0]);
        AssertionUtil.assertTrue(other.isTextType(), new Object[0]);
        TypeMirror type = TypeMirrorUtil.getTypeMirror(String.class, this.env);
        return TypeDeclaration.newTypeDeclaration(type, this.env);
    }

    public TypeDeclaration emulateArithmeticOperation(TypeDeclaration other) {
        AssertionUtil.assertNotNull(other);
        AssertionUtil.assertTrue(this.isNumberType(), new Object[0]);
        AssertionUtil.assertTrue(other.isNumberType(), new Object[0]);
        TypeMirror type = this.numberPriority >= other.numberPriority ? this.type : other.type;
        return TypeDeclaration.newTypeDeclaration(type, this.env);
    }

    public boolean isSameType(TypeDeclaration other) {
        if (TypeMirrorUtil.isSameType(this.type, other.type, this.env)) {
            return true;
        }
        if (this.isNumberType() && other.isNumberType()) {
            return this.numberPriority == other.numberPriority;
        }
        return false;
    }

    public static TypeDeclaration newTypeDeclaration(Class<?> clazz, ProcessingEnvironment env) {
        AssertionUtil.assertNotNull(clazz);
        return TypeDeclaration.newTypeDeclaration(TypeMirrorUtil.getTypeMirror(clazz, env), env);
    }

    public static TypeDeclaration newTypeDeclaration(TypeMirror type, ProcessingEnvironment env) {
        AssertionUtil.assertNotNull((Object)type, (Object)env);
        TypeElement typeElement = TypeMirrorUtil.toTypeElement(type, env);
        HashMap<String, List<TypeParameterDeclaration>> map = new HashMap<String, List<TypeParameterDeclaration>>();
        TypeDeclaration.gatherTypeParameterDeclarations(type, map, env);
        TypeDeclaration typeDeclaration = new TypeDeclaration();
        typeDeclaration.type = type;
        typeDeclaration.typeElement = typeElement;
        typeDeclaration.typeParameterDeclarationsMap = map;
        typeDeclaration.env = env;
        typeDeclaration.numberPriority = TypeDeclaration.determineNumberPriority(typeElement, type);
        return typeDeclaration;
    }

    protected static int determineNumberPriority(TypeElement typeElement, TypeMirror type) {
        Integer result;
        if (typeElement != null && (result = NUMBER_PRIORITY_MAP.get(typeElement.getQualifiedName().toString())) != null) {
            return result;
        }
        result = NUMBER_PRIORITY_MAP.get(type.getKind().name().toLowerCase());
        if (result != null) {
            return result;
        }
        return 0;
    }

    public static TypeDeclaration newUnknownTypeDeclaration(ProcessingEnvironment env) {
        TypeDeclaration typeDeclaration = new TypeDeclaration();
        typeDeclaration.type = env.getTypeUtils().getNoType(TypeKind.NONE);
        typeDeclaration.typeParameterDeclarationsMap = Collections.emptyMap();
        typeDeclaration.env = env;
        return typeDeclaration;
    }

    public static TypeDeclaration newBooleanTypeDeclaration(ProcessingEnvironment env) {
        AssertionUtil.assertNotNull(env);
        TypeMirror type = TypeMirrorUtil.getTypeMirror(Boolean.TYPE, env);
        return TypeDeclaration.newTypeDeclaration(type, env);
    }

    protected static void gatherTypeParameterDeclarations(TypeMirror type, Map<String, List<TypeParameterDeclaration>> typeParameterDeclarationsMap, ProcessingEnvironment env) {
        TypeElement typeElement = TypeMirrorUtil.toTypeElement(type, env);
        if (typeElement == null) {
            return;
        }
        typeParameterDeclarationsMap.put(typeElement.getQualifiedName().toString(), TypeDeclaration.createTypeParameterDeclarations(typeElement, type, env));
        for (TypeMirror typeMirror : env.getTypeUtils().directSupertypes(type)) {
            TypeElement superElement = TypeMirrorUtil.toTypeElement(typeMirror, env);
            if (superElement == null || typeParameterDeclarationsMap.containsKey(superElement.getQualifiedName().toString())) continue;
            typeParameterDeclarationsMap.put(superElement.getQualifiedName().toString(), TypeDeclaration.createTypeParameterDeclarations(superElement, typeMirror, env));
            TypeDeclaration.gatherTypeParameterDeclarations(typeMirror, typeParameterDeclarationsMap, env);
        }
    }

    public static List<TypeParameterDeclaration> createTypeParameterDeclarations(TypeElement typeElement, TypeMirror type, ProcessingEnvironment env) {
        AssertionUtil.assertNotNull((Object)typeElement, (Object)type, (Object)env);
        ArrayList<TypeParameterDeclaration> list = new ArrayList<TypeParameterDeclaration>();
        Iterator<? extends TypeParameterElement> formalParams = typeElement.getTypeParameters().iterator();
        DeclaredType declaredType = TypeMirrorUtil.toDeclaredType(type, env);
        Iterator<? extends TypeMirror> actualParams = declaredType.getTypeArguments().iterator();
        while (formalParams.hasNext() && actualParams.hasNext()) {
            TypeMirror formalType = formalParams.next().asType();
            TypeMirror actualType = actualParams.next();
            TypeParameterDeclaration typeParameterDeclaration = TypeParameterDeclaration.newInstance(formalType, actualType, env);
            list.add(typeParameterDeclaration);
        }
        return Collections.unmodifiableList(list);
    }

    static {
        NUMBER_PRIORITY_MAP.put(BigDecimal.class.getName(), 80);
        NUMBER_PRIORITY_MAP.put(BigInteger.class.getName(), 70);
        NUMBER_PRIORITY_MAP.put(Double.TYPE.getName(), 60);
        NUMBER_PRIORITY_MAP.put(Double.class.getName(), 60);
        NUMBER_PRIORITY_MAP.put(Float.TYPE.getName(), 50);
        NUMBER_PRIORITY_MAP.put(Float.class.getName(), 50);
        NUMBER_PRIORITY_MAP.put(Long.TYPE.getName(), 40);
        NUMBER_PRIORITY_MAP.put(Long.class.getName(), 40);
        NUMBER_PRIORITY_MAP.put(Integer.TYPE.getName(), 30);
        NUMBER_PRIORITY_MAP.put(Integer.class.getName(), 30);
        NUMBER_PRIORITY_MAP.put(Short.TYPE.getName(), 20);
        NUMBER_PRIORITY_MAP.put(Short.class.getName(), 20);
        NUMBER_PRIORITY_MAP.put(Byte.TYPE.getName(), 10);
        NUMBER_PRIORITY_MAP.put(Byte.class.getName(), 10);
    }
}

