/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.type;

import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeMirror;
import org.seasar.doma.Domain;
import org.seasar.doma.EnumDomain;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.type.AbstractDataType;
import org.seasar.doma.internal.apt.type.BasicType;
import org.seasar.doma.internal.apt.type.DataTypeVisitor;
import org.seasar.doma.internal.apt.util.TypeMirrorUtil;
import org.seasar.doma.internal.util.AssertionUtil;

public class DomainType
extends AbstractDataType {
    protected BasicType basicType;

    public DomainType(TypeMirror type, ProcessingEnvironment env) {
        super(type, env);
    }

    public BasicType getBasicType() {
        return this.basicType;
    }

    public static DomainType newInstance(TypeMirror type, ProcessingEnvironment env) {
        AssertionUtil.assertNotNull((Object)type, (Object)env);
        TypeElement typeElement = TypeMirrorUtil.toTypeElement(type, env);
        if (typeElement == null) {
            return null;
        }
        TypeMirror valueTypeMirror = DomainType.getValueType(typeElement);
        if (valueTypeMirror == null) {
            return null;
        }
        BasicType basicType = BasicType.newInstance(valueTypeMirror, env);
        if (basicType == null) {
            return null;
        }
        DomainType domainType = new DomainType(type, env);
        domainType.basicType = basicType;
        return domainType;
    }

    protected static TypeMirror getValueType(TypeElement typeElement) {
        Domain domain = typeElement.getAnnotation(Domain.class);
        if (domain != null) {
            return DomainType.getValueType(domain);
        }
        EnumDomain enumDomain = typeElement.getAnnotation(EnumDomain.class);
        if (enumDomain != null) {
            return DomainType.getValueType(enumDomain);
        }
        return null;
    }

    protected static TypeMirror getValueType(Domain domain) {
        try {
            domain.valueType();
        }
        catch (MirroredTypeException e) {
            return e.getTypeMirror();
        }
        throw new AptIllegalStateException("unreachable.");
    }

    protected static TypeMirror getValueType(EnumDomain enumDomain) {
        try {
            enumDomain.valueType();
        }
        catch (MirroredTypeException e) {
            return e.getTypeMirror();
        }
        throw new AptIllegalStateException("unreachable.");
    }

    @Override
    public <R, P, TH extends Throwable> R accept(DataTypeVisitor<R, P, TH> visitor, P p) throws TH {
        return visitor.visitDomainType(this, p);
    }
}

