/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.type;

import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.seasar.doma.internal.apt.type.AbstractDataType;
import org.seasar.doma.internal.apt.type.AnyType;
import org.seasar.doma.internal.apt.type.BasicType;
import org.seasar.doma.internal.apt.type.DataType;
import org.seasar.doma.internal.apt.type.DataTypeVisitor;
import org.seasar.doma.internal.apt.type.DomainType;
import org.seasar.doma.internal.apt.type.EntityType;
import org.seasar.doma.internal.apt.type.MapType;
import org.seasar.doma.internal.apt.util.TypeMirrorUtil;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.IterationCallback;

public class IterationCallbackType
extends AbstractDataType {
    protected TypeMirror returnTypeMirror;
    protected TypeMirror targetTypeMirror;
    protected AnyType returnType;
    protected DataType targetType;
    protected boolean rawType;

    public IterationCallbackType(TypeMirror type, ProcessingEnvironment env) {
        super(type, env);
    }

    public AnyType getReturnType() {
        return this.returnType;
    }

    public DataType getTargetType() {
        return this.targetType;
    }

    public boolean isRawType() {
        return this.returnTypeMirror == null || this.targetTypeMirror == null;
    }

    public boolean isWildcardType() {
        return this.returnTypeMirror != null && this.returnTypeMirror.getKind() == TypeKind.WILDCARD || this.targetTypeMirror != null && this.targetTypeMirror.getKind() == TypeKind.WILDCARD;
    }

    public static IterationCallbackType newInstance(TypeMirror type, ProcessingEnvironment env) {
        AssertionUtil.assertNotNull((Object)type, (Object)env);
        DeclaredType iterationCallbackDeclaredType = IterationCallbackType.getIterationCallbackDeclaredType(type, env);
        if (iterationCallbackDeclaredType == null) {
            return null;
        }
        IterationCallbackType callbackType = new IterationCallbackType(type, env);
        List<? extends TypeMirror> typeArguments = iterationCallbackDeclaredType.getTypeArguments();
        if (typeArguments.size() == 2) {
            callbackType.returnTypeMirror = typeArguments.get(0);
            callbackType.targetTypeMirror = typeArguments.get(1);
            callbackType.returnType = AnyType.newInstance(callbackType.returnTypeMirror, env);
            callbackType.targetType = EntityType.newInstance(callbackType.targetTypeMirror, env);
            if (callbackType.targetType == null) {
                callbackType.targetType = DomainType.newInstance(callbackType.targetTypeMirror, env);
                if (callbackType.targetType == null) {
                    callbackType.targetType = BasicType.newInstance(callbackType.targetTypeMirror, env);
                    if (callbackType.targetType == null) {
                        callbackType.targetType = MapType.newInstance(callbackType.targetTypeMirror, env);
                        if (callbackType.targetType == null) {
                            callbackType.targetType = AnyType.newInstance(callbackType.targetTypeMirror, env);
                        }
                    }
                }
            }
        }
        return callbackType;
    }

    protected static DeclaredType getIterationCallbackDeclaredType(TypeMirror type, ProcessingEnvironment env) {
        if (TypeMirrorUtil.isSameType(type, IterationCallback.class, env)) {
            return TypeMirrorUtil.toDeclaredType(type, env);
        }
        for (TypeMirror typeMirror : env.getTypeUtils().directSupertypes(type)) {
            if (TypeMirrorUtil.isSameType(typeMirror, IterationCallback.class, env)) {
                return TypeMirrorUtil.toDeclaredType(typeMirror, env);
            }
            IterationCallbackType.getIterationCallbackDeclaredType(typeMirror, env);
        }
        return null;
    }

    @Override
    public <R, P, TH extends Throwable> R accept(DataTypeVisitor<R, P, TH> visitor, P p) throws TH {
        return visitor.visitIterationCallbackType(this, p);
    }
}

